
import gurobipy as gp

# Create a new model
m = gp.Model("computer_competence_optimization")

# Create variables
george_hours = m.addVar(vtype=gp.GRB.INTEGER, name="george_hours")
john_hours = m.addVar(vtype=gp.GRB.CONTINUOUS, name="john_hours")
jean_hours = m.addVar(vtype=gp.GRB.INTEGER, name="jean_hours")
bobby_hours = m.addVar(vtype=gp.GRB.CONTINUOUS, name="bobby_hours")

# Set objective function
m.setObjective(3 * george_hours + 6 * john_hours + 5 * jean_hours + 1 * bobby_hours, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(4 * john_hours + 6 * jean_hours + 9 * bobby_hours >= 45, "c1")
m.addConstr(10 * george_hours + 4 * john_hours + 6 * jean_hours >= 45, "c2")
m.addConstr(4 * john_hours + 6 * jean_hours + 9 * bobby_hours >= 50, "c3")
m.addConstr(10 * george_hours + 4 * john_hours + 6 * jean_hours >= 50, "c4")
m.addConstr(10 * george_hours + 4 * john_hours <= 240, "c5")
m.addConstr(6 * jean_hours + 9 * bobby_hours <= 265, "c6")
m.addConstr(10 * george_hours + 4 * john_hours + 9 * bobby_hours <= 175, "c7")
m.addConstr(10 * george_hours + 4 * john_hours + 6 * jean_hours + 9 * bobby_hours <= 175, "c8")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('George Hours: %g' % george_hours.x)
    print('John Hours: %g' % john_hours.x)
    print('Jean Hours: %g' % jean_hours.x)
    print('Bobby Hours: %g' % bobby_hours.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

