
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
G = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_George")
J = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_John")
Je = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Jean")
B = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Bobby")

# Objective function
m.setObjective(3*G + 6*J + 5*Je + B, GRB.MAXIMIZE)

# Constraints
m.addConstr(4*J + 6*Je + 9*B >= 45, "min_total_competence_1")
m.addConstr(10*G + 4*J + 6*Je >= 45, "min_total_competence_2")
m.addConstr(4*J + 6*Je + 9*B >= 50, "min_total_competence_3")
m.addConstr(10*G + 4*J + 6*Je >= 50, "min_total_competence_4")
m.addConstr(10*G + 4*J <= 240, "max_total_competence_1")
m.addConstr(6*Je + 9*B <= 265, "max_total_competence_2")
m.addConstr(10*G + 4*J + 9*B <= 175, "max_total_competence_3")
m.addConstr(10*G + 4*J + 6*Je + 9*B <= 175, "max_total_competence_4")

# Solve the model
m.optimize()

# Print solution
for v in m.getVars():
    print("%s %f" % (v.varName, v.x))
print("Objective:", m.objVal)
