
import gurobi as gp

# Define the model
m = gp.Model("optimization_problem")

# Define the variables
hours_worked_by_George = m.addVar(name="hours_worked_by_George", integer=True)  # Integer constraint
hours_worked_by_John = m.addVar(name="hours_worked_by_John")  # Continuous
hours_worked_by_Jean = m.addVar(name="hours_worked_by_Jean", integer=True)  # Integer constraint
hours_worked_by_Bobby = m.addVar(name="hours_worked_by_Bobby")  # Continuous

# Objective function
m.setObjective(3 * hours_worked_by_George + 6 * hours_worked_by_John + 5 * hours_worked_by_Jean + hours_worked_by_Bobby, gp.GRB.MAXIMIZE)

# Constraints
# Computer competence ratings
r0_x0 = 10; r0_x1 = 4; r0_x2 = 6; r0_x3 = 9

# Constraint 2: John, Jean, Bobby >= 45
m.addConstr(r0_x1 * hours_worked_by_John + r0_x2 * hours_worked_by_Jean + r0_x3 * hours_worked_by_Bobby >= 45)

# Constraint 3: George, John, Jean >= 45
m.addConstr(r0_x0 * hours_worked_by_George + r0_x1 * hours_worked_by_John + r0_x2 * hours_worked_by_Jean >= 45)

# Constraint 4: John, Jean, Bobby >= 50
m.addConstr(r0_x1 * hours_worked_by_John + r0_x2 * hours_worked_by_Jean + r0_x3 * hours_worked_by_Bobby >= 50)

# Constraint 5: George, John, Jean >= 50
m.addConstr(r0_x0 * hours_worked_by_George + r0_x1 * hours_worked_by_John + r0_x2 * hours_worked_by_Jean >= 50)

# Constraint 6: George, John <= 240
m.addConstr(r0_x0 * hours_worked_by_George + r0_x1 * hours_worked_by_John <= 240)

# Constraint 7: Jean, Bobby <= 265
m.addConstr(r0_x2 * hours_worked_by_Jean + r0_x3 * hours_worked_by_Bobby <= 265)

# Constraint 8: George, John, Bobby <= 175
m.addConstr(r0_x0 * hours_worked_by_George + r0_x1 * hours_worked_by_John + r0_x3 * hours_worked_by_Bobby <= 175)

# Constraint 9: All <= 175
m.addConstr(r0_x0 * hours_worked_by_George + r0_x1 * hours_worked_by_John + r0_x2 * hours_worked_by_Jean + r0_x3 * hours_worked_by_Bobby <= 175)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hours worked by George: ", hours_worked_by_George.varValue)
    print("Hours worked by John: ", hours_worked_by_John.varValue)
    print("Hours worked by Jean: ", hours_worked_by_Jean.varValue)
    print("Hours worked by Bobby: ", hours_worked_by_Bobby.varValue)
else:
    print("The model is infeasible.")
