
from gurobipy import Model, GRB

# Create a new model
model = Model("food_optimization")

# Create variables
hot_dogs = model.addVar(vtype=GRB.INTEGER, name="hot_dogs")
strawberries = model.addVar(vtype=GRB.INTEGER, name="strawberries")
apple_pies = model.addVar(vtype=GRB.INTEGER, name="apple_pies")
peanutbutter_sandwiches = model.addVar(vtype=GRB.INTEGER, name="peanutbutter_sandwiches")
kiwis = model.addVar(vtype=GRB.INTEGER, name="kiwis")

# Set objective function
model.setObjective(9 * hot_dogs + 7 * strawberries + 4 * apple_pies + 7 * peanutbutter_sandwiches + 3 * kiwis, GRB.MINIMIZE)

# Add constraints
model.addConstr(2 * hot_dogs + 17 * strawberries + 15 * apple_pies + 26 * peanutbutter_sandwiches + 25 * kiwis <= 662, "c0") # Carbohydrate limit
model.addConstr(8 * hot_dogs + 12 * strawberries + 1 * apple_pies + 2 * peanutbutter_sandwiches + 4 * kiwis <= 256, "c1") # Iron limit

model.addConstr(2 * hot_dogs + 25 * kiwis >= 130, "c2")
model.addConstr(17 * strawberries + 25 * kiwis >= 73, "c3")
model.addConstr(2 * hot_dogs + 26 * peanutbutter_sandwiches >= 77, "c4")
model.addConstr(2 * hot_dogs + 17 * strawberries >= 104, "c5")
model.addConstr(26 * peanutbutter_sandwiches + 25 * kiwis >= 87, "c6")
model.addConstr(15 * apple_pies + 26 * peanutbutter_sandwiches >= 84, "c7")
model.addConstr(17 * strawberries + 26 * peanutbutter_sandwiches >= 48, "c8")
model.addConstr(17 * strawberries + 26 * peanutbutter_sandwiches + 25 * kiwis >= 78, "c9")
model.addConstr(2 * hot_dogs + 17 * strawberries + 15 * apple_pies + 26 * peanutbutter_sandwiches + 25 * kiwis >= 78, "c10")

model.addConstr(1 * apple_pies + 4 * kiwis >= 42, "c11")
model.addConstr(8 * hot_dogs + 1 * apple_pies >= 30, "c12")
model.addConstr(12 * strawberries + 2 * peanutbutter_sandwiches >= 35, "c13")
model.addConstr(8 * hot_dogs + 2 * peanutbutter_sandwiches >= 18, "c14")
model.addConstr(8 * hot_dogs + 12 * strawberries >= 46, "c15")
model.addConstr(2 * peanutbutter_sandwiches + 4 * kiwis >= 51, "c16")
model.addConstr(12 * strawberries + 4 * kiwis >= 32, "c17")
model.addConstr(8 * hot_dogs + 12 * strawberries + 4 * kiwis >= 27, "c18")
model.addConstr(8 * hot_dogs + 12 * strawberries + 1 * apple_pies + 2 * peanutbutter_sandwiches + 4 * kiwis >= 27, "c19")

model.addConstr(9 * strawberries - 3 * kiwis >= 0, "c20")
model.addConstr(-2 * apple_pies + 5 * kiwis >= 0, "c21")

model.addConstr(2 * hot_dogs + 25 * kiwis <= 433, "c22")
model.addConstr(2 * hot_dogs + 26 * peanutbutter_sandwiches + 25 * kiwis <= 458, "c23")
model.addConstr(17 * strawberries + 15 * apple_pies + 25 * kiwis <= 553, "c24")
model.addConstr(12 * strawberries + 1 * apple_pies + 4 * kiwis <= 230, "c25")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")
