
import gurobi

# Create a new Gurobi model
m = gurobi.Model()

# Define variables
hot_dogs = m.addVar(name="hot_dogs", vtype=gurobi.GRB.INTEGER)
strawberries = m.addVar(name="strawberries", vtype=gurobi.GRB.INTEGER)
apple_pies = m.addVar(name="apple_pies", vtype=gurobi.GRB.INTEGER)
peanutbutter_sandwiches = m.addVar(name="peanutbutter_sandwiches", vtype=gurobi.GRB.INTEGER)
kiwis = m.addVar(name="kiwis", vtype=gurobi.GRB.INTEGER)

# Objective function
m.setObjective(9 * hot_dogs + 7 * strawberries + 4 * apple_pies + 7 * peanutbutter_sandwiches + 3 * kiwis, gurobi.GRB.MINIMIZE)

# Resource constraints
m.addConstr(2 * hot_dogs + 17 * strawberries + 15 * apple_pies + 26 * peanutbutter_sandwiches + 25 * kiwis <= 662, name="carbohydrates")
m.addConstr(8 * hot_dogs + 12 * strawberries + apple_pies + 2 * peanutbutter_sandwiches + 4 * kiwis <= 256, name="iron")

# Carbohydrate constraints
m.addConstr(2 * hot_dogs + 25 * kiwis >= 130, name="carbohydrates_hot_dogs_kiwis")
m.addConstr(17 * strawberries + 25 * kiwis >= 73, name="carbohydrates_strawberries_kiwis")
m.addConstr(2 * hot_dogs + 26 * peanutbutter_sandwiches >= 77, name="carbohydrates_hot_dogs_peanutbutter_sandwiches")
m.addConstr(2 * hot_dogs + 17 * strawberries >= 104, name="carbohydrates_hot_dogs_strawberries")
m.addConstr(26 * peanutbutter_sandwiches + 25 * kiwis >= 87, name="carbohydrates_peanutbutter_sandwiches_kiwis")
m.addConstr(15 * apple_pies + 26 * peanutbutter_sandwiches >= 84, name="carbohydrates_apple_pies_peanutbutter_sandwiches")
m.addConstr(17 * strawberries + 26 * peanutbutter_sandwiches >= 48, name="carbohydrates_strawberries_peanutbutter_sandwiches")
m.addConstr(17 * strawberries + 26 * peanutbutter_sandwiches + 25 * kiwis >= 78, name="carbohydrates_strawberries_peanutbutter_sandwiches_kiwis")
m.addConstr(2 * hot_dogs + 17 * strawberries + 15 * apple_pies + 26 * peanutbutter_sandwiches + 25 * kiwis >= 78, name="carbohydrates_all")
m.addConstr(2 * hot_dogs + 25 * kiwis <= 433, name="carbohydrates_hot_dogs_kiwis_upper")
m.addConstr(2 * hot_dogs + 26 * peanutbutter_sandwiches + 25 * kiwis <= 458, name="carbohydrates_hot_dogs_peanutbutter_sandwiches_kiwis_upper")
m.addConstr(17 * strawberries + 15 * apple_pies + 25 * kiwis <= 553, name="carbohydrates_strawberries_apple_pies_kiwis_upper")

# Iron constraints
m.addConstr(apple_pies + 4 * kiwis >= 42, name="iron_apple_pies_kiwis")
m.addConstr(8 * hot_dogs + apple_pies >= 30, name="iron_hot_dogs_apple_pies")
m.addConstr(12 * strawberries + 2 * peanutbutter_sandwiches >= 35, name="iron_strawberries_peanutbutter_sandwiches")
m.addConstr(8 * hot_dogs + 2 * peanutbutter_sandwiches >= 18, name="iron_hot_dogs_peanutbutter_sandwiches")
m.addConstr(8 * hot_dogs + 12 * strawberries >= 46, name="iron_hot_dogs_strawberries")
m.addConstr(2 * peanutbutter_sandwiches + 4 * kiwis >= 51, name="iron_peanutbutter_sandwiches_kiwis")
m.addConstr(12 * strawberries + 4 * kiwis >= 32, name="iron_strawberries_kiwis")
m.addConstr(8 * hot_dogs + 12 * strawberries + 4 * kiwis >= 27, name="iron_hot_dogs_strawberries_kiwis")
m.addConstr(8 * hot_dogs + 12 * strawberries + apple_pies + 2 * peanutbutter_sandwiches + 4 * kiwis >= 27, name="iron_all")
m.addConstr(12 * strawberries + apple_pies + 4 * kiwis <= 230, name="iron_strawberries_apple_pies_kiwis_upper")

# Linear constraints
m.addConstr(9 * strawberries - 3 * kiwis >= 0, name="linear_strawberries_kiwis")
m.addConstr(-2 * apple_pies + 5 * kiwis >= 0, name="linear_apple_pies_kiwis")

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hot dogs: ", hot_dogs.varValue)
    print("Strawberries: ", strawberries.varValue)
    print("Apple pies: ", apple_pies.varValue)
    print("Peanutbutter sandwiches: ", peanutbutter_sandwiches.varValue)
    print("Kiwis: ", kiwis.varValue)
else:
    print("No optimal solution found")
