
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
oranges = m.addVar(lb=0, name="oranges")
granola_bars = m.addVar(lb=0, name="granola_bars")
protein_bars = m.addVar(lb=0, name="protein_bars")
sashimi = m.addVar(lb=0, name="sashimi")

# Set objective function
m.setObjective(4.12 * oranges + 5.22 * granola_bars + 7.71 * protein_bars + 1.9 * sashimi, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(5 * oranges + 7 * granola_bars + 15 * protein_bars + 13 * sashimi <= 233, "r0_sourness")
m.addConstr(17 * oranges + 7 * granola_bars + 7 * protein_bars + 14 * sashimi <= 389, "r1_umami")
m.addConstr(12 * oranges + 17 * granola_bars + 17 * protein_bars + 7 * sashimi <= 404, "r2_protein")
m.addConstr(8 * oranges + 5 * granola_bars + 9 * protein_bars + 9 * sashimi <= 420, "r3_iron")
m.addConstr(5 * oranges + 14 * granola_bars + 14 * protein_bars + 4 * sashimi <= 175, "r4_cost")

m.addConstr(7 * granola_bars + 15 * protein_bars >= 55, "c1")
m.addConstr(5 * oranges + 7 * granola_bars >= 57, "c2")
m.addConstr(15 * protein_bars + 13 * sashimi >= 26, "c3")
m.addConstr(7 * granola_bars + 15 * protein_bars + 13 * sashimi >= 50, "c4")
m.addConstr(5 * oranges + 7 * granola_bars + 15 * protein_bars + 13 * sashimi >= 50, "c5")

m.addConstr(7 * protein_bars + 14 * sashimi >= 95, "c6")
m.addConstr(17 * oranges + 7 * granola_bars >= 79, "c7")
m.addConstr(17 * oranges + 14 * sashimi >= 60, "c8")
m.addConstr(7 * granola_bars + 14 * sashimi >= 53, "c9")
m.addConstr(17 * oranges + 7 * granola_bars + 14 * sashimi >= 87, "c10")
m.addConstr(17 * oranges + 7 * granola_bars + 7 * protein_bars >= 87, "c11")
m.addConstr(17 * oranges + 7 * granola_bars + 14 * sashimi >= 84, "c12")
m.addConstr(17 * oranges + 7 * granola_bars + 7 * protein_bars >= 84, "c13")
m.addConstr(17 * oranges + 7 * granola_bars + 7 * protein_bars + 14 * sashimi >= 84, "c14")

m.addConstr(17 * granola_bars + 7 * sashimi >= 50, "c15")
m.addConstr(12 * oranges + 17 * protein_bars >= 66, "c16")
m.addConstr(12 * oranges + 17 * granola_bars >= 72, "c17")
m.addConstr(12 * oranges + 17 * granola_bars + 17 * protein_bars + 7 * sashimi >= 72, "c18")

m.addConstr(5 * granola_bars + 9 * sashimi >= 95, "c19")
m.addConstr(8 * oranges + 5 * granola_bars >= 70, "c20")
m.addConstr(5 * granola_bars + 9 * protein_bars >= 84, "c21")
m.addConstr(8 * oranges + 5 * granola_bars + 9 * protein_bars + 9 * sashimi >= 84, "c22")

m.addConstr(5 * oranges + 14 * granola_bars >= 19, "c23")
m.addConstr(14 * protein_bars + 4 * sashimi >= 20, "c24")
m.addConstr(5 * oranges + 4 * sashimi >= 31, "c25")
m.addConstr(14 * granola_bars + 4 * sashimi >= 27, "c26")
m.addConstr(5 * oranges + 14 * protein_bars >= 34, "c27")
m.addConstr(14 * granola_bars + 14 * protein_bars >= 28, "c28")
m.addConstr(5 * oranges + 14 * protein_bars + 4 * sashimi >= 25, "c29")
m.addConstr(5 * oranges + 14 * granola_bars + 14 * protein_bars >= 25, "c30")
m.addConstr(5 * oranges + 14 * protein_bars + 4 * sashimi >= 39, "c31")
m.addConstr(5 * oranges + 14 * granola_bars + 14 * protein_bars >= 39, "c32")
m.addConstr(5 * oranges + 14 * granola_bars + 14 * protein_bars + 4 * sashimi >= 39, "c33")


m.addConstr(7 * oranges - 2 * sashimi >= 0, "c34")
m.addConstr(15 * protein_bars + 13 * sashimi <= 216, "c35")
m.addConstr(7 * granola_bars + 13 * sashimi <= 158, "c36")
m.addConstr(7 * granola_bars + 7 * protein_bars <= 354, "c37")
m.addConstr(17 * oranges + 7 * granola_bars + 14 * sashimi <= 379, "c38")
m.addConstr(17 * oranges + 7 * protein_bars + 14 * sashimi <= 177, "c39")
m.addConstr(12 * oranges + 7 * sashimi <= 169, "c40")
m.addConstr(12 * oranges + 17 * protein_bars + 7 * sashimi <= 129, "c41")
m.addConstr(8 * oranges + 9 * sashimi <= 135, "c42")
m.addConstr(5 * granola_bars + 9 * protein_bars <= 338, "c43")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)
