
import gurobi as gp

# Define the model
m = gp.Model("optimization_problem")

# Define the variables
oranges = m.addVar(name="oranges", lb=0)  # No lower bound specified, assuming 0
granola_bars = m.addVar(name="granola_bars", lb=0)
protein_bars = m.addVar(name="protein_bars", lb=0)
sashimi = m.addVar(name="sashimi", lb=0)

# Define the objective function
m.setObjective(4.12 * oranges + 5.22 * granola_bars + 7.71 * protein_bars + 1.9 * sashimi, gp.GRB.MINIMIZE)

# Constraints
# Resource constraints
m.addConstr(oranges * 5 + granola_bars * 7 + protein_bars * 15 + sashimi * 13 <= 233, "sourness_index")
m.addConstr(oranges * 17 + granola_bars * 7 + protein_bars * 7 + sashimi * 14 <= 389, "umami_index")
m.addConstr(oranges * 12 + granola_bars * 17 + protein_bars * 17 + sashimi * 7 <= 404, "grams_of_protein")
m.addConstr(oranges * 8 + granola_bars * 5 + protein_bars * 9 + sashimi * 9 <= 420, "milligrams_of_iron")
m.addConstr(oranges * 5 + granola_bars * 14 + protein_bars * 14 + sashimi * 4 <= 175, "dollar_cost")

# Specific constraints
m.addConstr(granola_bars * 7 + protein_bars * 15 >= 55, "sourness_granola_protein")
m.addConstr(oranges * 5 + granola_bars * 7 >= 57, "sourness_oranges_granola")
m.addConstr(protein_bars * 15 + sashimi * 13 >= 26, "sourness_protein_sashimi")
m.addConstr(granola_bars * 7 + protein_bars * 15 + sashimi * 13 >= 50, "sourness_granola_protein_sashimi")
m.addConstr(oranges * 5 + granola_bars * 7 + protein_bars * 15 + sashimi * 13 >= 50, "sourness_all")

m.addConstr(protein_bars * 7 + sashimi * 14 >= 95, "umami_protein_sashimi")
m.addConstr(oranges * 17 + granola_bars * 7 >= 79, "umami_oranges_granola")
m.addConstr(oranges * 17 + sashimi * 14 >= 60, "umami_oranges_sashimi")
m.addConstr(granola_bars * 7 + sashimi * 14 >= 53, "umami_granola_sashimi")
m.addConstr(oranges * 17 + granola_bars * 7 + sashimi * 14 >= 87, "umami_oranges_granola_sashimi")
m.addConstr(oranges * 17 + granola_bars * 7 + protein_bars * 7 >= 87, "umami_oranges_granola_protein")
m.addConstr(oranges * 17 + granola_bars * 7 + sashimi * 14 >= 84, "umami_oranges_granola_sashimi_2")
m.addConstr(oranges * 17 + granola_bars * 7 + protein_bars * 7 >= 84, "umami_oranges_granola_protein_2")
m.addConstr(oranges * 17 + granola_bars * 7 + protein_bars * 7 + sashimi * 14 >= 84, "umami_all")

m.addConstr(granola_bars * 17 + sashimi * 7 >= 50, "protein_granola_sashimi")
m.addConstr(oranges * 12 + protein_bars * 17 >= 66, "protein_oranges_protein")
m.addConstr(oranges * 12 + granola_bars * 17 >= 72, "protein_oranges_granola")
m.addConstr(oranges * 12 + granola_bars * 17 + protein_bars * 17 + sashimi * 7 >= 72, "protein_all")

m.addConstr(granola_bars * 5 + sashimi * 9 >= 95, "iron_granola_sashimi")
m.addConstr(oranges * 8 + granola_bars * 5 >= 70, "iron_oranges_granola")
m.addConstr(granola_bars * 5 + protein_bars * 9 >= 84, "iron_granola_protein")
m.addConstr(oranges * 8 + granola_bars * 5 + protein_bars * 9 + sashimi * 9 >= 84, "iron_all")

# Cost constraints
m.addConstr(oranges * 5 + granola_bars * 14 >= 19, "cost_oranges_granola")
m.addConstr(protein_bars * 14 + sashimi * 4 >= 20, "cost_protein_sashimi")
m.addConstr(oranges * 5 + sashimi * 4 >= 31, "cost_oranges_sashimi")
m.addConstr(granola_bars * 14 + sashimi * 4 >= 27, "cost_granola_sashimi")
m.addConstr(oranges * 5 + protein_bars * 14 >= 34, "cost_oranges_protein")
m.addConstr(granola_bars * 14 + protein_bars * 14 >= 28, "cost_granola_protein")
m.addConstr(oranges * 5 + protein_bars * 14 + sashimi * 4 >= 25, "cost_oranges_protein_sashimi")
m.addConstr(oranges * 5 + granola_bars * 14 + protein_bars * 14 >= 25, "cost_oranges_granola_protein")
m.addConstr(oranges * 5 + protein_bars * 14 + sashimi * 4 >= 39, "cost_oranges_protein_sashimi_2")
m.addConstr(oranges * 5 + granola_bars * 14 + protein_bars * 14 >= 39, "cost_oranges_granola_protein_2")
m.addConstr(oranges * 5 + granola_bars * 14 + protein_bars * 14 + sashimi * 4 >= 39, "cost_all")

# Other constraints
m.addConstr(7 * oranges - 2 * sashimi >= 0, "other_constraint_1")
m.addConstr(protein_bars * 15 + sashimi * 13 <= 216, "sourness_protein_sashimi_max")
m.addConstr(granola_bars * 7 + sashimi * 13 <= 158, "sourness_granola_sashimi_max")
m.addConstr(granola_bars * 7 + protein_bars * 7 <= 354, "umami_granola_protein_max")
m.addConstr(oranges * 17 + granola_bars * 7 + sashimi * 14 <= 379, "umami_oranges_granola_sashimi_max")
m.addConstr(oranges * 17 + protein_bars * 7 + sashimi * 14 <= 177, "umami_oranges_protein_sashimi_max")
m.addConstr(oranges * 12 + sashimi * 7 <= 169, "protein_oranges_sashimi_max")
m.addConstr(oranges * 12 + protein_bars * 17 + sashimi * 7 <= 129, "protein_oranges_protein_sashimi_max")
m.addConstr(oranges * 8 + sashimi * 9 <= 135, "iron_oranges_sashimi_max")
m.addConstr(granola_bars * 5 + protein_bars * 9 <= 338, "iron_granola_protein_max")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Oranges: ", oranges.varValue)
    print("Granola Bars: ", granola_bars.varValue)
    print("Protein Bars: ", protein_bars.varValue)
    print("Sashimi: ", sashimi.varValue)
else:
    print("The model is infeasible")
