
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
peanutbutter_sandwiches = m.addVar(vtype=gp.GRB.CONTINUOUS, name="peanutbutter_sandwiches")
granola_bars = m.addVar(vtype=gp.GRB.CONTINUOUS, name="granola_bars")
chicken_thighs = m.addVar(vtype=gp.GRB.CONTINUOUS, name="chicken_thighs")
pickles = m.addVar(vtype=gp.GRB.CONTINUOUS, name="pickles")

# Set objective function
m.setObjective(3.35 * peanutbutter_sandwiches**2 + 8.9 * peanutbutter_sandwiches * granola_bars + 1.56 * peanutbutter_sandwiches * chicken_thighs + 9.04 * chicken_thighs * pickles, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(21.24 * peanutbutter_sandwiches + 6.28 * granola_bars + 6.16 * chicken_thighs + 4.23 * pickles <= 374, "Total Fat")
m.addConstr(21.24 * peanutbutter_sandwiches**2 + 4.23 * pickles**2 >= 84, "Fat from PB Sandwiches and Pickles")
m.addConstr(6.16 * chicken_thighs**2 + 4.23 * pickles**2 >= 87, "Fat from Chicken Thighs and Pickles")
m.addConstr(6.28 * granola_bars + 4.23 * pickles >= 89, "Fat from Granola Bars and Pickles")
m.addConstr(21.24 * peanutbutter_sandwiches + 6.28 * granola_bars + 4.23 * pickles >= 57, "Fat from PB, Granola, and Pickles")
m.addConstr(21.24 * peanutbutter_sandwiches + 6.16 * chicken_thighs + 4.23 * pickles >= 57, "Fat from PB, Chicken, and Pickles")
m.addConstr(21.24 * peanutbutter_sandwiches + 6.28 * granola_bars + 6.16 * chicken_thighs >= 57, "Fat from PB, Granola, and Chicken")
m.addConstr(21.24 * peanutbutter_sandwiches + 6.28 * granola_bars + 4.23 * pickles >= 79, "Fat from PB, Granola, and Pickles (2)")
m.addConstr(21.24 * peanutbutter_sandwiches + 6.16 * chicken_thighs + 4.23 * pickles >= 79, "Fat from PB, Chicken, and Pickles (2)")
m.addConstr(21.24 * peanutbutter_sandwiches + 6.28 * granola_bars + 6.16 * chicken_thighs >= 79, "Fat from PB, Granola, and Chicken (2)")
m.addConstr(21.24 * peanutbutter_sandwiches + 6.28 * granola_bars + 4.23 * pickles >= 71, "Fat from PB, Granola, and Pickles (3)")
m.addConstr(21.24 * peanutbutter_sandwiches + 6.16 * chicken_thighs + 4.23 * pickles >= 71, "Fat from PB, Chicken, and Pickles (3)")
m.addConstr(21.24 * peanutbutter_sandwiches + 6.28 * granola_bars + 6.16 * chicken_thighs >= 71, "Fat from PB, Granola, and Chicken (3)")
m.addConstr(21.24 * peanutbutter_sandwiches + 6.28 * granola_bars + 6.16 * chicken_thighs + 4.23 * pickles >= 71, "Fat from all")
m.addConstr(9 * peanutbutter_sandwiches**2 - granola_bars**2 >= 0, "Quadratic Constraint 1")
m.addConstr(9 * peanutbutter_sandwiches - 3 * chicken_thighs >= 0, "Linear Constraint 1")
m.addConstr(6.16 * chicken_thighs + 4.23 * pickles <= 108, "Fat from Chicken and Pickles (Upper Bound)")
m.addConstr(21.24 * peanutbutter_sandwiches + 4.23 * pickles <= 185, "Fat from PB and Pickles (Upper Bound)")
m.addConstr(21.24 * peanutbutter_sandwiches + 6.16 * chicken_thighs + 4.23 * pickles <= 338, "Fat from PB, Chicken, and Pickles (Upper Bound)")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found:")
    for v in m.getVars():
        print(f"{v.varName}: {v.x}")
    print(f"Objective value: {m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}.")

