
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="chicken breasts", vtype=gurobi.GRB.INTEGER)
x1 = m.addVar(name="potatoes", vtype=gurobi.GRB.INTEGER)
x2 = m.addVar(name="tomatoes", vtype=gurobi.GRB.INTEGER)
x3 = m.addVar(name="milkshakes", vtype=gurobi.GRB.INTEGER)

# Objective function
m.setObjective(3.29 * x0 + 7.22 * x1 + 7.31 * x2 + 4.91 * x3, gurobi.GRB.MINIMIZE)

# Constraints
# Calcium constraints
m.addConstr(1 * x0 + 3 * x3 >= 28, name="calcium_chicken_milkshakes")
m.addConstr(8 * x1 + 9 * x2 >= 29, name="calcium_potatoes_tomatoes")
m.addConstr(1 * x0 + 8 * x1 + 9 * x2 + 3 * x3 >= 29, name="total_calcium")

# Iron constraints
m.addConstr(5 * x0 + 6 * x2 >= 31, name="iron_chicken_tomatoes")
m.addConstr(7 * x1 + 4 * x3 >= 33, name="iron_potatoes_milkshakes")
m.addConstr(7 * x1 + 6 * x2 >= 26, name="iron_potatoes_tomatoes")
m.addConstr(5 * x0 + 7 * x1 + 6 * x2 + 4 * x3 >= 26, name="total_iron")

# Fiber constraints
m.addConstr(1 * x1 + 1 * x2 >= 41, name="fiber_potatoes_tomatoes")
m.addConstr(3 * x0 + 1 * x2 >= 38, name="fiber_chicken_tomatoes")
m.addConstr(1 * x2 + 8 * x3 >= 18, name="fiber_tomatoes_milkshakes")
m.addConstr(3 * x0 + 1 * x2 + 8 * x3 >= 39, name="fiber_chicken_tomatoes_milkshakes")
m.addConstr(1 * x1 + 1 * x2 + 8 * x3 >= 39, name="fiber_potatoes_tomatoes_milkshakes")
m.addConstr(3 * x0 + 1 * x1 + 1 * x2 + 8 * x3 >= 22, name="fiber_all")

# Iron upper bound constraints
m.addConstr(5 * x0 + 7 * x1 <= 139, name="iron_chicken_potatoes_ub")
m.addConstr(7 * x1 + 4 * x3 <= 108, name="iron_potatoes_milkshakes_ub")
m.addConstr(5 * x0 + 4 * x3 <= 85, name="iron_chicken_milkshakes_ub")
m.addConstr(7 * x1 + 6 * x2 <= 139, name="iron_potatoes_tomatoes_ub")
m.addConstr(5 * x0 + 7 * x1 + 6 * x2 + 4 * x3 <= 159, name="total_iron_ub")
m.addConstr(5 * x0 + 7 * x1 + 4 * x3 <= 61, name="iron_chicken_potatoes_milkshakes_ub")
m.addConstr(5 * x0 + 7 * x1 + 6 * x2 <= 54, name="iron_chicken_potatoes_tomatoes_ub")

# Fiber upper bound constraints
m.addConstr(3 * x0 + 8 * x3 <= 126, name="fiber_chicken_milkshakes_ub")
m.addConstr(1 * x1 + 8 * x3 <= 161, name="fiber_potatoes_milkshakes_ub")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objval)
    print("Chicken breasts: ", x0.varValue)
    print("Potatoes: ", x1.varValue)
    print("Tomatoes: ", x2.varValue)
    print("Milkshakes: ", x3.varValue)
else:
    print("The model is infeasible")
