
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    bill_hours = model.addVar(name="bill_hours", lb=0)  # Assuming hours cannot be negative
    bobby_hours = model.addVar(name="bobby_hours", lb=0)  # Assuming hours cannot be negative

    # Define the objective function
    model.setObjective(4.11 * bill_hours + 4.49 * bobby_hours, gurobi.GRB.MINIMIZE)

    # Define the constraints
    model.addConstr(4 * bill_hours + 9 * bobby_hours >= 38, name="dollar_cost_constraint")
    model.addConstr(bill_hours + 3 * bobby_hours >= 46, name="likelihood_to_quit_constraint")
    model.addConstr(-2 * bill_hours + 2 * bobby_hours >= 0, name="hours_worked_constraint")
    model.addConstr(4 * bill_hours + 9 * bobby_hours <= 87, name="dollar_cost_upper_bound")
    model.addConstr(bill_hours + 3 * bobby_hours <= 94, name="likelihood_to_quit_upper_bound")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by Bill: {bill_hours.varValue}")
        print(f"Hours worked by Bobby: {bobby_hours.varValue}")
        print(f"Objective function value: {model.objVal}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("No feasible solution found.")
    else:
        print("Optimization failed.")

solve_optimization_problem()
