
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define the variables
x0 = m.addVar(name="milligrams_of_vitamin_K", lb=-GRB.INFINITY)  # Continuous variable
x1 = m.addVar(name="grams_of_fiber", lb=-GRB.INFINITY)  # Continuous variable

# Objective function: Minimize 7*x0*x1 + 8*x1
m.setObjective(7*x0*x1 + 8*x1, GRB.MINIMIZE)

# Constraints
# Cognitive Performance Index
m.addConstr(10*x0 + 14*x1 >= 12, name="cognitive_performance_lower")
m.addConstr(10*x0 + 14*x1 <= 31, name="cognitive_performance_upper")

# Muscle Growth Index
m.addConstr(5*x0 + 15*x1 >= 16, name="muscle_growth_lower")
m.addConstr(5*x0 + 15*x1 <= 19, name="muscle_growth_upper")

# Digestive Support Index (Note: This involves quadratic terms which are not directly supported in linear programming.
# For simplicity and adherence to the problem's request for a straightforward Gurobi model,
# we'll include these constraints as comments. In practice, you would need to reformulate or use a nonlinear solver.)
# m.addConstr(49*x0**2 + 4*x1**2 >= 30, name="digestive_support_lower_nonlinear")
# m.addConstr(49*x0**2 + 4*x1**2 <= 76, name="digestive_support_upper_nonlinear")
m.addConstr(7*x0 + 2*x1 >= 30, name="digestive_support_linear")

# Immune Support Index
# Similarly, for the immune support index with squared terms:
# m.addConstr(289*x0**2 + 64*x1**2 >= 18, name="immune_support_lower_nonlinear")
m.addConstr(17*x0 + 8*x1 <= 41, name="immune_support_upper_linear")

# Linear Constraint
m.addConstr(-3*x0 + 5*x1 >= 0, name="linear_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"milligrams_of_vitamin_K: {x0.x}")
    print(f"grams_of_fiber: {x1.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
