
import gurobi

def optimize_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="milligrams_of_vitamin_K", lb=0)  # Assuming non-negative
    x1 = model.addVar(name="grams_of_fiber", lb=0)  # Assuming non-negative

    # Objective function
    model.setObjective(7 * x0 * x1 + 8 * x1, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(10 * x0 + 14 * x1 >= 12, name="cognitive_performance")
    model.addConstr(5 * x0 + 15 * x1 >= 16, name="muscle_growth")
    model.addConstr(7 * x0**2 + 2 * x1**2 >= 30, name="digestive_support")
    model.addConstr(17 * x0**2 + 8 * x1**2 >= 18, name="immune_support")
    model.addConstr(-3 * x0 + 5 * x1 >= 0, name="linear_constraint")
    model.addConstr(10 * x0**2 + 14 * x1**2 <= 31, name="cognitive_performance_squared")
    model.addConstr(5 * x0 + 15 * x1 <= 19, name="muscle_growth_squared")
    model.addConstr(7 * x0**2 + 2 * x1**2 <= 76, name="digestive_support_squared")
    model.addConstr(17 * x0 + 8 * x1 <= 41, name="immune_support_linear")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin K: {x0.varValue}")
        print(f"Grams of fiber: {x1.varValue}")
        print(f"Objective function value: {model.objVal}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("The model has a non-optimal status.")

optimize_problem()
