
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
protein = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="protein")
potassium = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="potassium")
vitamin_b4 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b4")
vitamin_b3 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b3")

# Set objective function
m.setObjective(8.14 * protein + 4.73 * potassium + 7.96 * vitamin_b4 + 3.19 * vitamin_b3, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(6 * protein + 28 * potassium + 1 * vitamin_b4 + 22 * vitamin_b3 >= 127, "c1")
m.addConstr(6 * protein + 28 * potassium >= 104, "c2")
m.addConstr(28 * potassium + 22 * vitamin_b3 >= 147, "c3")
m.addConstr(1 * vitamin_b4 + 22 * vitamin_b3 >= 167, "c4")
m.addConstr(6 * protein + 28 * potassium + 22 * vitamin_b3 >= 111, "c5")
m.addConstr(6 * protein + 28 * potassium + 1 * vitamin_b4 + 22 * vitamin_b3 >= 111, "c6")

m.addConstr(5 * protein + 9 * vitamin_b4 >= 91, "c7")
m.addConstr(5 * protein + 8 * vitamin_b3 >= 71, "c8")
m.addConstr(4 * potassium + 9 * vitamin_b4 >= 114, "c9")
m.addConstr(5 * protein + 4 * potassium + 9 * vitamin_b4 + 8 * vitamin_b3 >= 114, "c10")

m.addConstr(28 * protein + 12 * vitamin_b3 >= 121, "c11")
m.addConstr(28 * protein + 26 * vitamin_b4 >= 68, "c12")
m.addConstr(26 * vitamin_b4 + 12 * vitamin_b3 >= 108, "c13")
m.addConstr(28 * protein + 26 * potassium >= 120, "c14")
m.addConstr(26 * potassium + 12 * vitamin_b3 >= 108, "c15")
m.addConstr(28 * protein + 26 * potassium + 12 * vitamin_b3 >= 108, "c16")
m.addConstr(28 * protein + 26 * vitamin_b4 + 12 * vitamin_b3 >= 108, "c17")
m.addConstr(28 * protein + 26 * potassium + 12 * vitamin_b3 >= 146, "c18")
m.addConstr(28 * protein + 26 * vitamin_b4 + 12 * vitamin_b3 >= 146, "c19")
m.addConstr(28 * protein + 26 * potassium + 26 * vitamin_b4 + 12 * vitamin_b3 >= 146, "c20")

m.addConstr(vitamin_b4 - 5 * vitamin_b3 >= 0, "c21")

m.addConstr(1 * vitamin_b4 + 22 * vitamin_b3 <= 553, "c22")
m.addConstr(28 * potassium + 1 * vitamin_b4 <= 554, "c23")
m.addConstr(6 * protein + 22 * vitamin_b3 <= 231, "c24")
m.addConstr(6 * protein + 28 * potassium <= 178, "c25")
m.addConstr(6 * protein + 28 * potassium + 22 * vitamin_b3 <= 508, "c26")
m.addConstr(6 * protein + 1 * vitamin_b4 + 22 * vitamin_b3 <= 304, "c27")

m.addConstr(5 * protein + 4 * potassium <= 411, "c28")
m.addConstr(5 * protein + 8 * vitamin_b3 <= 539, "c29")
m.addConstr(4 * potassium + 9 * vitamin_b4 <= 357, "c30")
m.addConstr(4 * potassium + 8 * vitamin_b3 <= 445, "c31")
m.addConstr(5 * protein + 9 * vitamin_b4 <= 266, "c32")
m.addConstr(5 * protein + 4 * potassium + 8 * vitamin_b3 <= 459, "c33")
m.addConstr(5 * protein + 9 * vitamin_b4 + 8 * vitamin_b3 <= 322, "c34")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)
