
import gurobi

def optimize():
    model = gurobi.Model()
    
    # Define variables
    x0 = model.addVar(name="grams_of_protein", lb=0)
    x1 = model.addVar(name="milligrams_of_potassium", lb=0)
    x2 = model.addVar(name="milligrams_of_vitamin_B4", lb=0)
    x3 = model.addVar(name="milligrams_of_vitamin_B3", lb=0)

    # Objective function
    model.setObjective(8.14 * x0 + 4.73 * x1 + 7.96 * x2 + 3.19 * x3, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(6 * x0 <= 693)
    model.addConstr(5 * x0 <= 670)
    model.addConstr(28 * x0 <= 610)
    model.addConstr(28 * x1 <= 693)
    model.addConstr(4 * x1 <= 670)
    model.addConstr(26 * x1 <= 610)
    model.addConstr(x2 <= 693)
    model.addConstr(9 * x2 <= 670)
    model.addConstr(26 * x2 <= 610)
    model.addConstr(22 * x3 <= 693)
    model.addConstr(8 * x3 <= 670)
    model.addConstr(12 * x3 <= 610)
    model.addConstr(6 * x0 + 22 * x3 >= 127)
    model.addConstr(6 * x0 + 28 * x1 >= 104)
    model.addConstr(28 * x1 + 22 * x3 >= 147)
    model.addConstr(x2 + 22 * x3 >= 167)
    model.addConstr(6 * x0 + 28 * x1 + 22 * x3 >= 111)
    model.addConstr(6 * x0 + 28 * x1 + x2 + 22 * x3 >= 111)
    model.addConstr(5 * x0 + 9 * x2 >= 91)
    model.addConstr(5 * x0 + 8 * x3 >= 71)
    model.addConstr(4 * x1 + 9 * x2 >= 114)
    model.addConstr(5 * x0 + 4 * x1 + 9 * x2 + 8 * x3 >= 114)
    model.addConstr(28 * x0 + 12 * x3 >= 121)
    model.addConstr(28 * x0 + 26 * x2 >= 68)
    model.addConstr(26 * x2 + 12 * x3 >= 108)
    model.addConstr(28 * x0 + 26 * x1 >= 120)
    model.addConstr(26 * x1 + 12 * x3 >= 108)
    model.addConstr(28 * x0 + 26 * x1 + 12 * x3 >= 108)
    model.addConstr(28 * x0 + 26 * x2 + 12 * x3 >= 108)
    model.addConstr(28 * x0 + 26 * x1 + 12 * x3 >= 146)
    model.addConstr(28 * x0 + 26 * x2 + 12 * x3 >= 146)
    model.addConstr(28 * x0 + 26 * x1 + 26 * x2 + 12 * x3 >= 146)
    model.addConstr(x2 - 5 * x3 >= 0)
    model.addConstr(x2 + 22 * x3 <= 553)
    model.addConstr(28 * x1 + x2 <= 554)
    model.addConstr(6 * x0 + 22 * x3 <= 231)
    model.addConstr(6 * x0 + 28 * x1 <= 178)
    model.addConstr(6 * x0 + 28 * x1 + 22 * x3 <= 508)
    model.addConstr(6 * x0 + x2 + 22 * x3 <= 304)
    model.addConstr(5 * x0 + 4 * x1 <= 411)
    model.addConstr(5 * x0 + 8 * x3 <= 539)
    model.addConstr(4 * x1 + 9 * x2 <= 357)
    model.addConstr(4 * x1 + 8 * x3 <= 445)
    model.addConstr(5 * x0 + 9 * x2 <= 266)
    model.addConstr(5 * x0 + 4 * x1 + 8 * x3 <= 459)
    model.addConstr(5 * x0 + 9 * x2 + 8 * x3 <= 322)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("Grams of protein: ", x0.varValue)
        print("Milligrams of potassium: ", x1.varValue)
        print("Milligrams of vitamin B4: ", x2.varValue)
        print("Milligrams of vitamin B3: ", x3.varValue)
    else:
        print("The model is infeasible")

optimize()
