
from gurobipy import Model, GRB

# Create a new model
m = Model("optimization_problem")

# Create variables
squash_plants = m.addVar(vtype=GRB.INTEGER, name="squash_plants")
boxwoods = m.addVar(vtype=GRB.INTEGER, name="boxwoods")
zucchini_vines = m.addVar(vtype=GRB.INTEGER, name="zucchini_vines")
basil_plants = m.addVar(vtype=GRB.INTEGER, name="basil_plants")

# Set objective function
m.setObjective(6*squash_plants**2 + 4*squash_plants*boxwoods + 7*squash_plants*zucchini_vines + 7*squash_plants*basil_plants + 5*boxwoods**2 + 6*zucchini_vines**2 + 4*zucchini_vines*basil_plants + 5*basil_plants**2 + 2*squash_plants + 9*boxwoods + 6*zucchini_vines + 8*basil_plants, GRB.MAXIMIZE)

# Add constraints
m.addConstr(0.74 * squash_plants + 0.84 * basil_plants >= 13)
m.addConstr(0.55 * zucchini_vines + 0.84 * basil_plants >= 5)
m.addConstr((0.76 * boxwoods)**2 + (0.84 * basil_plants)**2 >= 11)
m.addConstr(0.74 * squash_plants + 0.55 * zucchini_vines >= 11)
m.addConstr(0.76 * boxwoods + 0.55 * zucchini_vines >= 10)
m.addConstr(-4 * squash_plants**2 + 7 * zucchini_vines**2 >= 0)
m.addConstr(0.34 * boxwoods + 0.46 * basil_plants <= 35)
m.addConstr(0.7 * squash_plants + 0.18 * zucchini_vines <= 18)
m.addConstr(0.7 * squash_plants + 0.46 * basil_plants <= 36)
m.addConstr((0.7 * squash_plants)**2 + (0.34 * boxwoods)**2 <= 10)
m.addConstr(0.7 * squash_plants + 0.34 * boxwoods + 0.18 * zucchini_vines + 0.46 * basil_plants <= 10)
m.addConstr(0.76 * boxwoods + 0.55 * zucchini_vines <= 36)
m.addConstr(0.74 * squash_plants + 0.55 * zucchini_vines <= 21)
m.addConstr(0.76 * boxwoods + 0.84 * basil_plants <= 16)
m.addConstr(0.74 * squash_plants + 0.76 * boxwoods <= 24)
m.addConstr(0.74 * squash_plants + 0.84 * basil_plants <= 35)
m.addConstr(0.74 * squash_plants + 0.76 * boxwoods + 0.55 * zucchini_vines + 0.84 * basil_plants <= 35)


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

