
import gurobi

# Create a new Gurobi model
m = gurobi.Model()

# Define the variables
s = m.addVar(name="squash_plants", vtype=gurobi.GRB.INTEGER)
b = m.addVar(name="boxwoods", vtype=gurobi.GRB.INTEGER)
z = m.addVar(name="zucchini_vines", vtype=gurobi.GRB.INTEGER)
d = m.addVar(name="basil_plants", vtype=gurobi.GRB.INTEGER)

# Objective function
m.setObjective(6*s**2 + 4*s*b + 7*s*z + 7*s*d + 5*b**2 + 6*z**2 + 4*z*d + 5*d**2 + 2*s + 9*b + 6*z + 8*d, gurobi.GRB.MAXIMIZE)

# Constraints
m.addConstr(s + d >= 13)
m.addConstr(z + d >= 5)
m.addConstr(b**2 + d**2 >= 11)
m.addConstr(0.74*s + 0.55*z >= 11)
m.addConstr(0.76*b + 0.55*z >= 10)
m.addConstr(-4*s**2 + 7*z**2 >= 0)
m.addConstr(0.34*b + 0.46*d <= 35)
m.addConstr(0.7*s + 0.18*z <= 18)
m.addConstr(0.7*s + 0.46*d <= 36)
m.addConstr((0.7*s)**2 + (0.34*b)**2 <= 10)
m.addConstr(0.7*s + 0.34*b + 0.18*z + 0.46*d <= 10)
m.addConstr(0.76*b + 0.55*z <= 36)
m.addConstr(0.74*s + 0.55*z <= 21)
m.addConstr(0.76*b + 0.84*d <= 16)
m.addConstr(0.74*s + 0.76*b <= 24)
m.addConstr(0.74*s + 0.84*d <= 35)
m.addConstr(0.74*s + 0.76*b + 0.55*z + 0.84*d <= 35)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Squash plants: ", s.varValue)
    print("Boxwoods: ", b.varValue)
    print("Zucchini vines: ", z.varValue)
    print("Basil plants: ", d.varValue)
else:
    print("The model is infeasible")
