
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables as integers
lanyards = m.addVar(vtype=GRB.INTEGER, name="lanyards")
postage_stamps = m.addVar(vtype=GRB.INTEGER, name="postage_stamps")
cans_of_coffee = m.addVar(vtype=GRB.INTEGER, name="cans_of_coffee")

# Set the objective function
m.setObjective(7.8*lanyards + 3.65*postage_stamps + 4.87*cans_of_coffee, GRB.MINIMIZE)

# Add constraints
m.addConstr(17*lanyards + 6*cans_of_coffee >= 20)
m.addConstr(5*postage_stamps + 6*cans_of_coffee >= 12)
m.addConstr(17*lanyards + 5*postage_stamps + 6*cans_of_coffee >= 20)
m.addConstr(17*lanyards + 5*postage_stamps + 6*cans_of_coffee <= 39)

m.addConstr(12*lanyards + 8*cans_of_coffee >= 54)
m.addConstr(11*postage_stamps + 8*cans_of_coffee >= 52)
m.addConstr(12*lanyards + 11*postage_stamps + 8*cans_of_coffee >= 52)

m.addConstr(12*lanyards + 8*cans_of_coffee <= 151)
m.addConstr(12*lanyards + 11*postage_stamps <= 65)
m.addConstr(11*postage_stamps + 8*cans_of_coffee <= 101)

m.addConstr(lanyards - 3*postage_stamps >= 0)

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Lanyards: {lanyards.X}")
    print(f"Postage Stamps: {postage_stamps.X}")
    print(f"Cans of Coffee: {cans_of_coffee.X}")
else:
    print("No optimal solution found.")
