
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    lanyards = model.addVar(name="lanyards", vtype=gurobi.GRB.INTEGER)
    postage_stamps = model.addVar(name="postage_stamps", vtype=gurobi.GRB.INTEGER)
    cans_of_coffee = model.addVar(name="cans_of_coffee", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(7.8 * lanyards + 3.65 * postage_stamps + 4.87 * cans_of_coffee, gurobi.GRB.MINIMIZE)

    # Constraints
    # Sustainability score constraints
    model.addConstr(17 * lanyards + 6 * cans_of_coffee >= 20, name="sustainability_score_lanyards_cans")
    model.addConstr(5 * postage_stamps + 6 * cans_of_coffee >= 12, name="sustainability_score_postage_cans")
    model.addConstr(17 * lanyards + 5 * postage_stamps + 6 * cans_of_coffee >= 20, name="sustainability_score_all")
    model.addConstr(17 * lanyards + 5 * postage_stamps + 6 * cans_of_coffee <= 39, name="sustainability_score_all_upper")

    # Cost constraints
    model.addConstr(12 * lanyards + 8 * cans_of_coffee >= 54, name="cost_lanyards_cans")
    model.addConstr(11 * postage_stamps + 8 * cans_of_coffee >= 52, name="cost_postage_cans")
    model.addConstr(12 * lanyards + 11 * postage_stamps + 8 * cans_of_coffee >= 52, name="cost_all")
    model.addConstr(12 * lanyards + 11 * postage_stamps + 8 * cans_of_coffee <= 163, name="cost_all_upper")
    model.addConstr(12 * lanyards + 11 * postage_stamps <= 65, name="cost_lanyards_postage_upper")
    model.addConstr(11 * postage_stamps + 8 * cans_of_coffee <= 101, name="cost_postage_cans_upper")
    model.addConstr(12 * lanyards + 8 * cans_of_coffee <= 151, name="cost_lanyards_cans_upper")

    # Other constraints
    model.addConstr(lanyards - 3 * postage_stamps >= 0, name="lanyards_postage_constraint")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("Lanyards: ", lanyards.varValue)
        print("Postage Stamps: ", postage_stamps.varValue)
        print("Cans of Coffee: ", cans_of_coffee.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
