
from gurobipy import Model, GRB

# Create a new model
model = Model("optimization_problem")

# Create variables
strawberries = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="strawberries")
fruit_salads = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="fruit_salads")
potatoes = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="potatoes")
cherry_pies = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="cherry_pies")

# Set objective function
model.setObjective(6 * strawberries + 1 * fruit_salads + 2 * potatoes + 8 * cherry_pies, GRB.MINIMIZE)

# Add constraints
model.addConstr(7 * strawberries + 3 * cherry_pies >= 105, "c0")
model.addConstr(19 * fruit_salads + 3 * cherry_pies >= 86, "c1")
model.addConstr(7 * strawberries + 11 * potatoes >= 63, "c2")
model.addConstr(7 * strawberries + 19 * fruit_salads >= 75, "c3")
model.addConstr(7 * strawberries + 19 * fruit_salads + 3 * cherry_pies >= 55, "c4")
model.addConstr(7 * strawberries + 11 * potatoes + 3 * cherry_pies >= 55, "c5")
model.addConstr(7 * strawberries + 19 * fruit_salads + 3 * cherry_pies >= 68, "c6")
model.addConstr(7 * strawberries + 11 * potatoes + 3 * cherry_pies >= 68, "c7")
model.addConstr(7 * strawberries + 19 * fruit_salads + 11 * potatoes + 3 * cherry_pies >= 68, "c8")
model.addConstr(24 * fruit_salads + 21 * potatoes >= 22, "c9")
model.addConstr(24 * fruit_salads + 12 * cherry_pies >= 24, "c10")
model.addConstr(10 * strawberries + 21 * potatoes >= 37, "c11")
model.addConstr(10 * strawberries + 24 * fruit_salads + 21 * potatoes + 12 * cherry_pies >= 37, "c12")
model.addConstr(25 * strawberries + 28 * cherry_pies >= 59, "c13")
model.addConstr(11 * fruit_salads + 28 * cherry_pies >= 50, "c14")
model.addConstr(2 * potatoes + 28 * cherry_pies >= 54, "c15")
model.addConstr(25 * strawberries + 11 * fruit_salads + 28 * cherry_pies >= 60, "c16")
model.addConstr(11 * fruit_salads + 2 * potatoes + 28 * cherry_pies >= 60, "c17")
model.addConstr(25 * strawberries + 11 * fruit_salads + 2 * potatoes >= 60, "c18")
model.addConstr(25 * strawberries + 11 * fruit_salads + 28 * cherry_pies >= 50, "c19")
model.addConstr(11 * fruit_salads + 2 * potatoes + 28 * cherry_pies >= 50, "c20")
model.addConstr(25 * strawberries + 11 * fruit_salads + 2 * potatoes >= 50, "c21")
model.addConstr(25 * strawberries + 11 * fruit_salads + 28 * cherry_pies >= 93, "c22")
model.addConstr(11 * fruit_salads + 2 * potatoes + 28 * cherry_pies >= 93, "c23")
model.addConstr(25 * strawberries + 11 * fruit_salads + 2 * potatoes >= 93, "c24")
model.addConstr(25 * strawberries + 11 * fruit_salads + 2 * potatoes + 28 * cherry_pies >= 93, "c25")
model.addConstr(27 * fruit_salads + 16 * potatoes >= 44, "c26")
model.addConstr(7 * strawberries + 29 * cherry_pies >= 26, "c27")
model.addConstr(27 * fruit_salads + 29 * cherry_pies >= 33, "c28")
model.addConstr(27 * fruit_salads + 16 * potatoes + 29 * cherry_pies >= 31, "c29")
model.addConstr(7 * strawberries + 27 * fruit_salads + 16 * potatoes + 29 * cherry_pies >= 31, "c30")
model.addConstr(9 * strawberries - 9 * potatoes >= 0, "c31")
model.addConstr(5 * fruit_salads - 10 * cherry_pies >= 0, "c32")
model.addConstr(8 * strawberries - 6 * cherry_pies >= 0, "c33")
model.addConstr(25 * strawberries + 2 * potatoes <= 314, "c34")
model.addConstr(11 * fruit_salads + 28 * cherry_pies <= 318, "c35")
model.addConstr(2 * potatoes + 28 * cherry_pies <= 104, "c36")
model.addConstr(16 * potatoes + 29 * cherry_pies <= 117, "c37")
model.addConstr(27 * fruit_salads + 16 * potatoes <= 157, "c38")


# Resource constraints (provided in the problem description)
model.addConstr(7 * strawberries + 19 * fruit_salads + 11 * potatoes + 3 * cherry_pies <= 443, "r0")
model.addConstr(10 * strawberries + 24 * fruit_salads + 21 * potatoes + 12 * cherry_pies <= 165, "r1")
model.addConstr(25 * strawberries + 11 * fruit_salads + 2 * potatoes + 28 * cherry_pies <= 372, "r2")
model.addConstr(7 * strawberries + 27 * fruit_salads + 16 * potatoes + 29 * cherry_pies <= 213, "r3")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", model.status)

