
from gurobipy import Model, GRB

# Create a new model
m = Model("optimization_problem")

# Create variables
orange_trees = m.addVar(vtype=GRB.INTEGER, name="orange_trees")
basil_plants = m.addVar(vtype=GRB.INTEGER, name="basil_plants")
apple_trees = m.addVar(vtype=GRB.INTEGER, name="apple_trees")

# Set objective function
m.setObjective(9 * orange_trees + 8 * basil_plants + 3 * apple_trees, GRB.MAXIMIZE)

# Add constraints
m.addConstr(7 * orange_trees + 17 * basil_plants + 12 * apple_trees >= 38, "min_water_need")
m.addConstr(7 * orange_trees + 12 * apple_trees <= 162, "max_water_orange_apple")
m.addConstr(7 * orange_trees + 17 * basil_plants <= 78, "max_water_orange_basil")
m.addConstr(17 * basil_plants + 12 * apple_trees <= 131, "max_water_basil_apple")
m.addConstr(7 * orange_trees + 17 * basil_plants + 12 * apple_trees <= 131, "max_total_water_need")

m.addConstr(7 * orange_trees + 16 * basil_plants <= 218, "max_beauty_orange_basil")
m.addConstr(16 * basil_plants + 13 * apple_trees <= 205, "max_beauty_basil_apple")
m.addConstr(7 * orange_trees + 16 * basil_plants + 13 * apple_trees <= 205, "max_total_beauty")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('Orange Trees:', orange_trees.x)
    print('Basil Plants:', basil_plants.x)
    print('Apple Trees:', apple_trees.x)
elif m.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

