
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    orange_trees = model.addVar(lb=0, ub=None, vtype=gurobi.GRB.INTEGER, name="orange_trees")
    basil_plants = model.addVar(lb=0, ub=None, vtype=gurobi.GRB.INTEGER, name="basil_plants")
    apple_trees = model.addVar(lb=0, ub=None, vtype=gurobi.GRB.INTEGER, name="apple_trees")

    # Objective function
    model.setObjective(9 * orange_trees + 8 * basil_plants + 3 * apple_trees, gurobi.GRB.MAXIMIZE)

    # Water need constraints
    model.addConstr(7 * orange_trees + 17 * basil_plants + 12 * apple_trees >= 38, name="water_need_min")
    model.addConstr(7 * orange_trees + 12 * apple_trees <= 162, name="water_orange_apple_max")
    model.addConstr(7 * orange_trees + 17 * basil_plants <= 78, name="water_orange_basil_max")
    model.addConstr(17 * basil_plants + 12 * apple_trees <= 131, name="water_basil_apple_max")
    model.addConstr(7 * orange_trees + 17 * basil_plants + 12 * apple_trees <= 219, name="water_total_max")

    # Beauty rating constraints
    model.addConstr(7 * orange_trees + 16 * basil_plants <= 218, name="beauty_orange_basil_max")
    model.addConstr(16 * basil_plants + 13 * apple_trees <= 205, name="beauty_basil_apple_max")
    model.addConstr(7 * orange_trees + 16 * basil_plants + 13 * apple_trees <= 205, name="beauty_total_max")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Optimal Solution:")
        print(f"Orange Trees: {orange_trees.varValue}")
        print(f"Basil Plants: {basil_plants.varValue}")
        print(f"Apple Trees: {apple_trees.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
