
from gurobipy import Model, GRB

# Create a new model
model = Model("vitamin_optimization")

# Create variables
vitamin_e = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="vitamin_e")
vitamin_c = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="vitamin_c")

# Set objective function
model.setObjective(7 * vitamin_e + 5 * vitamin_c, GRB.MINIMIZE)

# Add constraints
model.addConstr(2 * vitamin_e + 2 * vitamin_c >= 34, "c1")  # Cardiovascular support index lower bound
model.addConstr(3 * vitamin_e + 7 * vitamin_c >= 11, "c2")  # Muscle growth index lower bound
model.addConstr(6 * vitamin_e - 4 * vitamin_c >= 0, "c3")   # Relationship between vitamins
model.addConstr(2 * vitamin_e + 2 * vitamin_c <= 72, "c4")  # Cardiovascular support index upper bound (from r0)
model.addConstr(3 * vitamin_e + 7 * vitamin_c <= 27, "c5")  # Muscle growth index upper bound (from r1)


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"  Milligrams of Vitamin E: {vitamin_e.x}")
    print(f"  Milligrams of Vitamin C: {vitamin_c.x}")
    print(f"  Objective Value: {model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

