
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_E")
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_C")

# Objective function: minimize 7*x0 + 5*x1
m.setObjective(7 * x0 + 5 * x1, GRB.MINIMIZE)

# Constraints
m.addConstr(2 * x0 + 2 * x1 >= 34, name="cardiovascular_support_index")
m.addConstr(3 * x0 + 7 * x1 >= 11, name="muscle_growth_index")
m.addConstr(6 * x0 - 4 * x1 >= 0, name="additional_constraint")
m.addConstr(2 * x0 + 2 * x1 <= 72, name="upper_bound_cardiovascular")
m.addConstr(3 * x0 + 7 * x1 <= 27, name="upper_bound_muscle_growth")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Milligrams of Vitamin E: {x0.x}")
    print(f"Milligrams of Vitamin C: {x1.x}")
else:
    print("No optimal solution found.")

