
import gurobi

def optimize_vitamins():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    vitamin_E = model.addVar(lb=0, name="milligrams of vitamin E")  # Can be fractional
    vitamin_C = model.addVar(lb=0, name="milligrams of vitamin C")  # Can be fractional

    # Objective function: Minimize 7 * vitamin_E + 5 * vitamin_C
    model.setObjective(7 * vitamin_E + 5 * vitamin_C, gurobi.GRB.MINIMIZE)

    # Constraints
    # 1. The cardiovascular support index for milligrams of vitamin E is 2.
    model.addConstraint(2 * vitamin_E <= 97)  # Assuming 97 is an upper bound for vitamin E's cardiovascular support

    # 2. The muscle growth index for milligrams of vitamin E is 3.
    model.addConstraint(3 * vitamin_E <= 29)  # Assuming 29 is an upper bound for vitamin E's muscle growth

    # 3 & 4. Directly considered in 5 & 6

    # 5. The total combined cardiovascular support index from milligrams of vitamin E plus milligrams of vitamin C has to be 34 or more.
    model.addConstraint(2 * vitamin_E + 2 * vitamin_C >= 34)

    # 6. The total combined muscle growth index from milligrams of vitamin E, and milligrams of vitamin C should be 11 or more.
    model.addConstraint(3 * vitamin_E + 7 * vitamin_C >= 11)

    # 7. six times the number of milligrams of vitamin E, plus -4 times the number of milligrams of vitamin C should be greater than or equal to zero.
    model.addConstraint(6 * vitamin_E - 4 * vitamin_C >= 0)

    # 8 & 9. The total combined cardiovascular support index from milligrams of vitamin E, and milligrams of vitamin C must be less than or equal to 72.
    model.addConstraint(2 * vitamin_E + 2 * vitamin_C <= 72)

    # 10. The total combined muscle growth index from milligrams of vitamin E plus milligrams of vitamin C has to be equal to or less than 27.
    model.addConstraint(3 * vitamin_E + 7 * vitamin_C <= 27)

    # Solve the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Milligrams of Vitamin E: {vitamin_E.varValue}")
        print(f"Milligrams of Vitamin C: {vitamin_C.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_vitamins()
