
import gurobi as gp

# Define the model
m = gp.Model("optimization_problem")

# Define the variables
H = m.addVar(name="H", lb=0)  # Hours worked by Hank
P = m.addVar(name="P", lb=0)  # Hours worked by Peggy
M = m.addVar(name="M", lb=0)  # Hours worked by Mary
D = m.addVar(name="D", lb=0, integrality=gp.GRB.INTEGER)  # Hours worked by Dale

# Objective function
m.setObjective(6*H**2 + 6*H*P + 9*H*M + 2*P**2 + 4*P*M + 9*P*D + 5*D**2 + 7*H + 7*P + 7*M, gp.GRB.MAXIMIZE)

# Constraints
# Productivity rating constraints
m.addConstr(7.78*H <= 198)
m.addConstr(4.57*P <= 198)
m.addConstr(2.91*M <= 198)
m.addConstr(5.28*D <= 198)

# Likelihood to quit index constraints
m.addConstr(7.7*H <= 197)
m.addConstr(8.32*P <= 197)
m.addConstr(6.3*M <= 197)
m.addConstr(8.37*D <= 197)

# Dollar cost per hour constraints
m.addConstr(1.01*H <= 122)
m.addConstr(0.91*P <= 122)
m.addConstr(8.59*M <= 122)
m.addConstr(4.06*D <= 122)

# Computer competence rating constraints
m.addConstr(6.02*H <= 182)
m.addConstr(6.71*P <= 182)
m.addConstr(2.0*M <= 182)
m.addConstr(6.5*D <= 182)

# Work quality rating constraints
m.addConstr(3.38*H <= 123)
m.addConstr(8.21*P <= 123)
m.addConstr(8.49*M <= 123)
m.addConstr(6.87*D <= 123)

# Additional constraints
m.addConstr((2.91*M)**2 + (5.28*D)**2 >= 18)
m.addConstr(7.78*H + 5.28*D >= 49)
m.addConstr((7.78*H)**2 + (2.91*M)**2 + (5.28*D)**2 >= 31)
m.addConstr(7.78*H + 4.57*P + 5.28*D >= 31)
m.addConstr(7.78*H + 2.91*M + 5.28*D >= 27)

# Likelihood to quit index constraints continued
m.addConstr((7.7*H)**2 + (8.32*P)**2 >= 43)
m.addConstr(8.32*P + 8.37*D >= 17)
m.addConstr(6.3*M + 8.37*D >= 29)
m.addConstr(7.7*H + 6.3*M >= 32)
m.addConstr((8.32*P)**2 + (6.3*M)**2 >= 25)
m.addConstr(8.32*P*M + 8.37*D*M >= 41)

# Dollar cost per hour constraints continued
m.addConstr(1.01*H + 8.59*M >= 24)
m.addConstr((0.91*P)**2 + (4.06*D)**2 >= 13)
m.addConstr(1.01*H + 4.06*D >= 19)
m.addConstr(8.59*M + 4.06*D >= 18)

# Computer competence rating constraints continued
m.addConstr((6.71*P)**2 + (2.0*M)**2 >= 16)
m.addConstr((6.02*H)**2 + (6.5*D)**2 >= 29)
m.addConstr((2.0*M)**2 + (6.5*D)**2 >= 42)
m.addConstr(6.02*H + 2.0*M >= 32)

# Work quality rating constraints continued
m.addConstr((8.21*P)**2 + (8.49*M)**2 + (6.87*D)**2 >= 16)
m.addConstr((3.38*H)**2 + (8.21*P)**2 + (8.49*M)**2 >= 16)

# Upper bound constraints
m.addConstr(4.57*P + 5.28*D <= 113)
m.addConstr(2.91*M + 5.28*D <= 109)
m.addConstr((7.78*H)**2 + (2.91*M)**2 <= 174)
m.addConstr(4.57*P*2.91*M <= 117)
m.addConstr(7.78*H + 5.28*D <= 139)
m.addConstr((4.57*P)**2 + (2.91*M)**2 + (5.28*D)**2 <= 132)
m.addConstr(7.78*H + 4.57*P + 5.28*D <= 195)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Hours worked by Hank:", H.varValue)
    print("Hours worked by Peggy:", P.varValue)
    print("Hours worked by Mary:", M.varValue)
    print("Hours worked by Dale:", D.varValue)
else:
    print("The model is infeasible")
