
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
protein = m.addVar(name="protein", lb=0)
zinc = m.addVar(name="zinc", lb=0)
fiber = m.addVar(name="fiber", lb=0)
vitamin_b4 = m.addVar(name="vitamin_b4", lb=0)

# Set objective function
m.setObjective(9 * protein + 5 * zinc + 4 * fiber + 5 * vitamin_b4, gp.GRB.MAXIMIZE)

# Add resource constraints
m.addConstr(1 * protein + 23 * zinc + 9 * fiber + 13 * vitamin_b4 <= 371, "r0_kidney_support")
m.addConstr(17 * protein + 14 * zinc + 21 * fiber + 7 * vitamin_b4 <= 277, "r1_energy_stability")
m.addConstr(15 * protein + 10 * zinc + 19 * fiber + 19 * vitamin_b4 <= 472, "r2_cardiovascular_support")


# Add additional constraints
m.addConstr(1 * protein + 9 * fiber >= 37, "kidney_protein_fiber")
m.addConstr(9 * fiber + 13 * vitamin_b4 >= 40, "kidney_fiber_b4")
m.addConstr(23 * zinc + 9 * fiber >= 45, "kidney_zinc_fiber")
m.addConstr(23 * zinc + 9 * fiber + 13 * vitamin_b4 >= 80, "kidney_zinc_fiber_b4")
m.addConstr(14 * zinc + 7 * vitamin_b4 >= 39, "energy_zinc_b4")
m.addConstr(17 * protein + 14 * zinc + 21 * fiber >= 64, "energy_protein_zinc_fiber_1")
m.addConstr(17 * protein + 14 * zinc + 7 * vitamin_b4 >= 64, "energy_protein_zinc_b4_1")
m.addConstr(17 * protein + 21 * fiber + 7 * vitamin_b4 >= 64, "energy_protein_fiber_b4_1")
m.addConstr(14 * zinc + 21 * fiber + 7 * vitamin_b4 >= 64, "energy_zinc_fiber_b4_1")
m.addConstr(17 * protein + 14 * zinc + 21 * fiber >= 66, "energy_protein_zinc_fiber_2")
m.addConstr(17 * protein + 14 * zinc + 7 * vitamin_b4 >= 66, "energy_protein_zinc_b4_2")
m.addConstr(17 * protein + 21 * fiber + 7 * vitamin_b4 >= 66, "energy_protein_fiber_b4_2")
m.addConstr(14 * zinc + 21 * fiber + 7 * vitamin_b4 >= 66, "energy_zinc_fiber_b4_2")

m.addConstr(17 * protein + 14 * zinc + 21 * fiber >= 50, "energy_protein_zinc_fiber_3")
m.addConstr(17 * protein + 14 * zinc + 7 * vitamin_b4 >= 50, "energy_protein_zinc_b4_3")
m.addConstr(17 * protein + 21 * fiber + 7 * vitamin_b4 >= 50, "energy_protein_fiber_b4_3")
m.addConstr(14 * zinc + 21 * fiber + 7 * vitamin_b4 >= 50, "energy_zinc_fiber_b4_3")

m.addConstr(17 * protein + 14 * zinc + 21 * fiber >= 36, "energy_protein_zinc_fiber_4")
m.addConstr(17 * protein + 14 * zinc + 7 * vitamin_b4 >= 36, "energy_protein_zinc_b4_4")
m.addConstr(17 * protein + 21 * fiber + 7 * vitamin_b4 >= 36, "energy_protein_fiber_b4_4")
m.addConstr(14 * zinc + 21 * fiber + 7 * vitamin_b4 >= 36, "energy_zinc_fiber_b4_4")


m.addConstr(10 * zinc + 19 * vitamin_b4 >= 110, "cardio_zinc_b4")
m.addConstr(15 * protein + 19 * fiber >= 59, "cardio_protein_fiber")
m.addConstr(10 * zinc + 19 * fiber >= 101, "cardio_zinc_fiber")
m.addConstr(15 * protein + 10 * zinc >= 81, "cardio_protein_zinc")
m.addConstr(19 * fiber + 19 * vitamin_b4 >= 88, "cardio_fiber_b4")

m.addConstr(5 * zinc - 2 * fiber + 9 * vitamin_b4 >= 0, "custom_constraint")

m.addConstr(protein + 13 * vitamin_b4 <= 355, "kidney_protein_b4_max")
m.addConstr(23 * zinc + 13 * vitamin_b4 <= 219, "kidney_zinc_b4_max")
m.addConstr(protein + 23 * zinc + 9 * fiber + 13 * vitamin_b4 <= 219, "kidney_all_max")

m.addConstr(14 * zinc + 21 * fiber <= 252, "energy_zinc_fiber_max")
m.addConstr(17 * protein + 21 * fiber <= 263, "energy_protein_fiber_max")
m.addConstr(14 * zinc + 7 * vitamin_b4 <= 199, "energy_zinc_b4_max")
m.addConstr(17 * protein + 14 * zinc <= 187, "energy_protein_zinc_max")
m.addConstr(17 * protein + 14 * zinc + 7 * vitamin_b4 <= 245, "energy_protein_zinc_b4_max")
m.addConstr(14 * zinc + 21 * fiber + 7 * vitamin_b4 <= 239, "energy_zinc_fiber_b4_max")
m.addConstr(17 * protein + 14 * zinc + 21 * fiber <= 117, "energy_protein_zinc_fiber_max")
m.addConstr(17 * protein + 21 * fiber + 7 * vitamin_b4 <= 96, "energy_protein_fiber_b4_max")
m.addConstr(17 * protein + 14 * zinc + 21 * fiber + 7 * vitamin_b4 <= 96, "energy_all_max")

m.addConstr(15 * protein + 19 * vitamin_b4 <= 434, "cardio_protein_b4_max")
m.addConstr(15 * protein + 10 * zinc <= 307, "cardio_protein_zinc_max")
m.addConstr(10 * zinc + 19 * vitamin_b4 <= 254, "cardio_zinc_b4_max")
m.addConstr(19 * fiber + 19 * vitamin_b4 <= 250, "cardio_fiber_b4_max")
m.addConstr(10 * zinc + 19 * fiber + 19 * vitamin_b4 <= 282, "cardio_zinc_fiber_b4_max")
m.addConstr(15 * protein + 10 * zinc + 19 * vitamin_b4 <= 248, "cardio_protein_zinc_b4_max")
m.addConstr(15 * protein + 10 * zinc + 19 * fiber <= 234, "cardio_protein_zinc_fiber_max")
m.addConstr(15 * protein + 10 * zinc + 19 * fiber + 19 * vitamin_b4 <= 234, "cardio_all_max")



# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

