
import gurobi

def optimize_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    M = model.addVar(lb=0, name="hours_worked_by_Mary")
    L = model.addVar(lb=0, name="hours_worked_by_Laura")
    R = model.addVar(lb=0, name="hours_worked_by_Ringo")
    J = model.addVar(lb=0, name="hours_worked_by_John")

    # Define the objective function
    model.setObjective(8.56 * M + 5.65 * L + 7.58 * R + 7.27 * J, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(1.6 * L + 3.99 * J >= 11)
    model.addConstr(6.26 * M + 1.6 * L >= 31)
    model.addConstr(1.6 * L + 5.57 * R >= 26)
    model.addConstr(5.57 * R + 3.99 * J >= 30)
    model.addConstr(6.26 * M + 1.6 * L + 5.57 * R + 3.99 * J >= 30)
    model.addConstr(0.76 * M + 4.04 * R >= 51)
    model.addConstr(4.04 * R + 5.11 * J >= 50)
    model.addConstr(0.76 * M + 5.92 * L >= 26)
    model.addConstr(5.92 * L + 4.04 * R >= 36)
    model.addConstr(0.76 * M + 5.92 * L + 4.04 * R + 5.11 * J >= 36)
    model.addConstr(-5 * M + 5 * J >= 0)
    model.addConstr(1.6 * L + 3.99 * J <= 50)
    model.addConstr(6.26 * M + 5.57 * R <= 95)
    model.addConstr(1.6 * L + 5.57 * R <= 79)
    model.addConstr(6.26 * M + 5.57 * R + 3.99 * J <= 99)
    model.addConstr(5.92 * L + 4.04 * R <= 75)
    model.addConstr(5.92 * L + 5.11 * J <= 174)
    model.addConstr(0.76 * M + 4.04 * R <= 227)
    model.addConstr(0.76 * M + 5.92 * L <= 188)
    model.addConstr(4.04 * R + 5.11 * J <= 67)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by Mary: {M.varValue}")
        print(f"Hours worked by Laura: {L.varValue}")
        print(f"Hours worked by Ringo: {R.varValue}")
        print(f"Hours worked by John: {J.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_problem()
