
import gurobipy as gp

# Create a new model
m = gp.Model("vitamin_optimization")

# Create variables
vitamin_e = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_e")
vitamin_d = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_d")
vitamin_b6 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b6")

# Set objective function
m.setObjective(8 * vitamin_e + 1 * vitamin_d + 8 * vitamin_b6, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(1.9 * vitamin_d + 0.03 * vitamin_b6 <= 65, "c1")
m.addConstr(1.79 * vitamin_e + 1.9 * vitamin_d <= 77, "c2")
m.addConstr(1.79 * vitamin_e + 1.9 * vitamin_d + 0.03 * vitamin_b6 <= 48, "c3")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('vitamin_e:', vitamin_e.x)
    print('vitamin_d:', vitamin_d.x)
    print('vitamin_b6:', vitamin_b6.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

