
from gurobipy import *

# Create a new model
m = Model("Vitamin_Optimization")

# Define the decision variables
x0 = m.addVar(name="milligrams_of_vitamin_E", lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS)
x1 = m.addVar(name="milligrams_of_vitamin_D", lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS)
x2 = m.addVar(name="milligrams_of_vitamin_B6", lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS)

# Define the objective function
m.setObjective(8*x0 + 1*x1 + 8*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(1.79*x0 + 1.9*x1 <= 77, name="vitamin_E_and_D_constraint")
m.addConstr(1.9*x1 + 0.03*x2 <= 65, name="vitamin_D_and_B6_constraint")
m.addConstr(1.79*x0 + 1.9*x1 + 0.03*x2 <= 48, name="all_vitamins_constraint")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print("Milligrams of Vitamin E:", x0.x)
    print("Milligrams of Vitamin D:", x1.x)
    print("Milligrams of Vitamin B6:", x2.x)
    print("Objective Function Value:", m.objVal)
else:
    print("No optimal solution found. Status:", m.status)

