
import gurobi

def optimize_vitamins():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="milligrams of vitamin E", lb=0)
    x1 = model.addVar(name="milligrams of vitamin D", lb=0)
    x2 = model.addVar(name="milligrams of vitamin B6", lb=0)

    # Define the objective function
    model.setObjective(8 * x0 + 1 * x1 + 8 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(1.9 * x1 + 0.03 * x2 <= 65)
    model.addConstr(1.79 * x0 + 1.9 * x1 <= 77)
    model.addConstr(1.79 * x0 + 1.9 * x1 + 0.03 * x2 <= 48)

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin E: {x0.varValue}")
        print(f"Milligrams of vitamin D: {x1.varValue}")
        print(f"Milligrams of vitamin B6: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("The model has a non-optimal status.")

optimize_vitamins()
