
import gurobipy as gp

# Create a new model
m = gp.Model("minimize_likelihood_to_quit")

# Create variables
ringo = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="ringo")
jean = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="jean")
hank = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hank")
dale = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="dale")
bill = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bill")
bobby = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bobby")
paul = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="paul")

# Set objective function
m.setObjective(9*ringo + 2*jean + 5*hank + 7*dale + bill + 4*bobby + 5*paul, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(3*jean + 8*bill >= 42)
m.addConstr(3*jean + 7*dale >= 16)
m.addConstr(8*bill + 6*paul >= 39)
m.addConstr(3*jean + 3*hank >= 25)
m.addConstr(3*hank + 5*bobby >= 36)
m.addConstr(7*dale + 8*bill >= 18)
m.addConstr(8*bill + 5*bobby >= 39)
m.addConstr(8*ringo + 3*hank >= 35)
m.addConstr(7*dale + 5*bobby >= 19)
m.addConstr(8*ringo + 3*jean >= 37)
m.addConstr(3*jean + 5*bobby >= 42)

m.addConstr(8*ringo + 3*jean + 3*hank >= 33)
m.addConstr(3*hank + 7*dale + 6*paul >= 33)
m.addConstr(3*jean + 7*dale + 5*bobby >= 33)
m.addConstr(8*ringo + 3*jean + 5*bobby >= 33)
m.addConstr(8*ringo + 7*dale + 8*bill >= 33)
m.addConstr(8*ringo + 3*hank + 8*bill >= 33)
m.addConstr(3*jean + 3*hank + 5*bobby >= 33)

m.addConstr(5*ringo - 4*dale >= 0)
m.addConstr(-6*ringo - 7*jean + 6*bill >= 0)
m.addConstr(-8*ringo + 4*jean + 3*dale >= 0)


m.addConstr(7*dale + 5*bobby <= 252)
m.addConstr(8*ringo + 6*paul <= 65)
m.addConstr(8*ringo + 7*dale <= 260)
m.addConstr(3*jean + 3*hank <= 172)
m.addConstr(3*jean + 6*paul <= 162)
m.addConstr(8*ringo + 3*hank + 7*dale <= 312)
m.addConstr(3*jean + 3*hank + 7*dale <= 253)
m.addConstr(8*bill + 5*bobby + 6*paul <= 129)
m.addConstr(3*jean + 7*dale + 6*paul <= 205)
m.addConstr(8*ringo + 3*jean + 6*paul <= 256)
m.addConstr(3*jean + 7*dale + 5*bobby <= 161)
m.addConstr(3*hank + 7*dale + 5*bobby <= 167)
m.addConstr(7*dale + 8*bill + 6*paul <= 85)
m.addConstr(8*ringo + 3*jean + 8*bill <= 335)
m.addConstr(8*ringo + 3*hank + 5*bobby <= 106)
m.addConstr(8*ringo + 8*bill + 6*paul <= 282)
m.addConstr(8*ringo + 3*hank + 8*bill <= 206)
m.addConstr(3*hank + 7*dale + 6*paul <= 284)
m.addConstr(8*ringo + 7*dale + 8*bill <= 143)
m.addConstr(8*ringo + 5*bobby + 6*paul <= 298)
m.addConstr(7*dale + 8*bill + 5*bobby <= 182)
m.addConstr(8*ringo + 3*jean + 5*bobby <= 120)
m.addConstr(3*hank + 8*bill + 6*paul <= 218)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % m.status)
