
import gurobi

def optimize_vitamins():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="milligrams of vitamin B2", lb=0)  # Vitamin B2
    x1 = model.addVar(name="milligrams of vitamin C", lb=0)  # Vitamin C
    x2 = model.addVar(name="milligrams of vitamin B7", lb=0)  # Vitamin B7

    # Objective function
    model.setObjective(9.96 * x0 + 9.49 * x1 + 2.05 * x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(4 * x0 <= 92, name="kidney_support_B2")
    model.addConstr(9 * x0 <= 134, name="immune_support_B2")
    model.addConstr(1 * x0 <= 135, name="digestive_support_B2")
    model.addConstr(7 * x0 <= 63, name="energy_stability_B2")

    model.addConstr(8 * x1 <= 92, name="kidney_support_C")
    model.addConstr(10 * x1 <= 134, name="immune_support_C")
    model.addConstr(8 * x1 <= 135, name="digestive_support_C")
    model.addConstr(2 * x1 <= 63, name="energy_stability_C")

    model.addConstr(14 * x2 <= 92, name="kidney_support_B7")
    model.addConstr(3 * x2 <= 134, name="immune_support_B7")
    model.addConstr(4 * x2 <= 135, name="digestive_support_B7")
    model.addConstr(14 * x2 <= 63, name="energy_stability_B7")

    model.addConstr(4 * x0 + 8 * x1 >= 16, name="kidney_support_B2_C")
    model.addConstr(4 * x0 + 14 * x2 >= 28, name="kidney_support_B2_B7")
    model.addConstr(4 * x0 + 8 * x1 + 14 * x2 >= 28, name="kidney_support_all")

    model.addConstr(10 * x1 + 3 * x2 >= 20, name="immune_support_C_B7")
    model.addConstr(9 * x0 + 3 * x2 >= 31, name="immune_support_B2_B7")
    model.addConstr(9 * x0 + 10 * x1 + 3 * x2 >= 31, name="immune_support_all")

    model.addConstr(1 * x0 + 4 * x2 >= 41, name="digestive_support_B2_B7")
    model.addConstr(1 * x0 + 8 * x1 >= 45, name="digestive_support_B2_C")
    model.addConstr(1 * x0 + 8 * x1 + 4 * x2 >= 24, name="digestive_support_all_2")

    model.addConstr(7 * x0 + 2 * x1 >= 16, name="energy_stability_B2_C")
    model.addConstr(7 * x0 + 14 * x2 >= 16, name="energy_stability_B2_B7")
    model.addConstr(7 * x0 + 2 * x1 + 14 * x2 >= 16, name="energy_stability_all")

    model.addConstr(-6 * x0 + 1 * x1 >= 0, name="B2_C_relation")
    model.addConstr(7 * x1 - 10 * x2 >= 0, name="C_B7_relation")

    model.addConstr(1 * x0 + 4 * x2 <= 117, name="digestive_support_B2_B7_max")
    model.addConstr(1 * x0 + 8 * x1 <= 45, name="digestive_support_B2_C_max")
    model.addConstr(7 * x0 + 14 * x2 <= 25, name="energy_stability_B2_B7_max")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin B2: {x0.varValue}")
        print(f"Milligrams of vitamin C: {x1.varValue}")
        print(f"Milligrams of vitamin B7: {x2.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_vitamins()
