
from gurobipy import *

# Create a model
m = Model("Optimization Problem")

# Define variables (integer)
bean_stalks = m.addVar(lb=0, vtype=GRB.INTEGER, name="bean_stalks")
orange_trees = m.addVar(lb=0, vtype=GRB.INTEGER, name="orange_trees")
pansies = m.addVar(lb=0, vtype=GRB.INTEGER, name="pansies")
apple_trees = m.addVar(lb=0, vtype=GRB.INTEGER, name="apple_trees")

# Objective function: Minimize total cost
m.setObjective(7.64 * bean_stalks + 4.45 * orange_trees + 6.11 * pansies + 7.77 * apple_trees, GRB.MINIMIZE)

# Constraints based on resilience index and quantities
m.addConstr(14.59 * bean_stalks + 17.7 * pansies >= 21)
m.addConstr(14.59 * bean_stalks + 8.06 * apple_trees >= 51)
m.addConstr(14.59 * bean_stalks + 19.86 * orange_trees >= 43)
m.addConstr(19.86 * orange_trees + 8.06 * apple_trees >= 49)
m.addConstr(14.59 * bean_stalks + 19.86 * orange_trees + 17.7 * pansies >= 50)
m.addConstr(19.86 * orange_trees + 17.7 * pansies + 8.06 * apple_trees >= 50)
m.addConstr(14.59 * bean_stalks + 19.86 * orange_trees + 17.7 * pansies >= 25)
m.addConstr(19.86 * orange_trees + 17.7 * pansies + 8.06 * apple_trees >= 25)
m.addConstr(14.59 * bean_stalks + 19.86 * orange_trees + 17.7 * pansies + 8.06 * apple_trees >= 25)
m.addConstr(-3 * bean_stalks + 1 * pansies >= 0)
m.addConstr(-7 * orange_trees + 2 * pansies >= 0)

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Bean Stalks: {bean_stalks.x}")
    print(f"Orange Trees: {orange_trees.x}")
    print(f"Pansies: {pansies.x}")
    print(f"Apple Trees: {apple_trees.x}")
else:
    print("No optimal solution found")
