
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    bean_stalks = model.addVar(lb=0, vtype=gurobi.GRB.INTEGER, name="bean_stalks")
    orange_trees = model.addVar(lb=0, vtype=gurobi.GRB.INTEGER, name="orange_trees")
    pansies = model.addVar(lb=0, vtype=gurobi.GRB.INTEGER, name="pansies")
    apple_trees = model.addVar(lb=0, vtype=gurobi.GRB.INTEGER, name="apple_trees")

    # Define objective function
    model.setObjective(7.64 * bean_stalks + 4.45 * orange_trees + 6.11 * pansies + 7.77 * apple_trees, gurobi.GRB.MINIMIZE)

    # Define resilience index constraints
    model.addConstr(14.59 * bean_stalks + 17.7 * pansies >= 21, name="resilience_bean_pansies")
    model.addConstr(14.59 * bean_stalks + 8.06 * apple_trees >= 51, name="resilience_bean_apple")
    model.addConstr(14.59 * bean_stalks + 19.86 * orange_trees >= 43, name="resilience_bean_orange")
    model.addConstr(19.86 * orange_trees + 8.06 * apple_trees >= 49, name="resilience_orange_apple")
    model.addConstr(14.59 * bean_stalks + 19.86 * orange_trees + 17.7 * pansies >= 50, name="resilience_bean_orange_pansies")
    model.addConstr(19.86 * orange_trees + 17.7 * pansies + 8.06 * apple_trees >= 50, name="resilience_orange_pansies_apple")
    model.addConstr(14.59 * bean_stalks + 19.86 * orange_trees + 17.7 * pansies >= 25, name="resilience_bean_orange_pansies_2")
    model.addConstr(19.86 * orange_trees + 17.7 * pansies + 8.06 * apple_trees >= 25, name="resilience_orange_pansies_apple_2")
    model.addConstr(14.59 * bean_stalks + 19.86 * orange_trees + 17.7 * pansies + 8.06 * apple_trees >= 25, name="resilience_all")

    # Define variable constraints
    model.addConstr(-3 * bean_stalks + 1 * pansies >= 0, name="variable_constraint_1")
    model.addConstr(-7 * orange_trees + 2 * pansies >= 0, name="variable_constraint_2")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Bean stalks: {bean_stalks.varValue}")
        print(f"Orange trees: {orange_trees.varValue}")
        print(f"Pansies: {pansies.varValue}")
        print(f"Apple trees: {apple_trees.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
