
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
steaks = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="steaks")
pasta = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="pasta")
hot_dogs = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hot_dogs")
cheeseburgers = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="cheeseburgers")

# Set objective function
m.setObjective(1 * steaks + 3 * pasta + 5 * hot_dogs + 3 * cheeseburgers, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(4 * pasta + 15 * hot_dogs >= 97, "c1")
m.addConstr(1 * steaks + 4 * pasta >= 93, "c2")
m.addConstr(1 * steaks + 4 * pasta + 4 * cheeseburgers >= 112, "c3")
m.addConstr(1 * steaks + 15 * hot_dogs + 4 * cheeseburgers >= 112, "c4")
m.addConstr(4 * pasta + 15 * hot_dogs + 4 * cheeseburgers >= 112, "c5")
m.addConstr(1 * steaks + 4 * pasta + 15 * hot_dogs >= 112, "c6")
m.addConstr(1 * steaks + 4 * pasta + 4 * cheeseburgers >= 136, "c7")
m.addConstr(1 * steaks + 15 * hot_dogs + 4 * cheeseburgers >= 136, "c8")
m.addConstr(4 * pasta + 15 * hot_dogs + 4 * cheeseburgers >= 136, "c9")
m.addConstr(1 * steaks + 4 * pasta + 15 * hot_dogs >= 136, "c10")
m.addConstr(1 * steaks + 4 * pasta + 4 * cheeseburgers >= 127, "c11")
m.addConstr(1 * steaks + 15 * hot_dogs + 4 * cheeseburgers >= 127, "c12")
m.addConstr(4 * pasta + 15 * hot_dogs + 4 * cheeseburgers >= 127, "c13")
m.addConstr(1 * steaks + 4 * pasta + 15 * hot_dogs >= 127, "c14")
m.addConstr(1 * steaks + 4 * pasta + 4 * cheeseburgers >= 135, "c15")
m.addConstr(1 * steaks + 15 * hot_dogs + 4 * cheeseburgers >= 135, "c16")
m.addConstr(4 * pasta + 15 * hot_dogs + 4 * cheeseburgers >= 135, "c17")
m.addConstr(1 * steaks + 4 * pasta + 15 * hot_dogs >= 135, "c18")
m.addConstr(1 * steaks + 4 * pasta + 15 * hot_dogs + 4 * cheeseburgers >= 135, "c19")
m.addConstr(18 * pasta + 34 * hot_dogs >= 112, "c20")
m.addConstr(3 * steaks + 34 * hot_dogs >= 107, "c21")
m.addConstr(3 * steaks + 18 * pasta >= 75, "c22")
m.addConstr(3 * steaks + 18 * pasta + 22 * cheeseburgers >= 103, "c23")
m.addConstr(3 * steaks + 18 * pasta + 34 * hot_dogs >= 103, "c24")
m.addConstr(3 * steaks + 34 * hot_dogs + 22 * cheeseburgers >= 103, "c25")
m.addConstr(3 * steaks + 18 * pasta + 22 * cheeseburgers >= 113, "c26")
m.addConstr(3 * steaks + 18 * pasta + 34 * hot_dogs >= 113, "c27")
m.addConstr(3 * steaks + 34 * hot_dogs + 22 * cheeseburgers >= 113, "c28")
m.addConstr(3 * steaks + 18 * pasta + 22 * cheeseburgers >= 90, "c29")
m.addConstr(3 * steaks + 18 * pasta + 34 * hot_dogs >= 90, "c30")
m.addConstr(3 * steaks + 34 * hot_dogs + 22 * cheeseburgers >= 90, "c31")
m.addConstr(3 * steaks + 18 * pasta + 34 * hot_dogs + 22 * cheeseburgers >= 90, "c32")
m.addConstr(-8 * steaks + 1 * cheeseburgers >= 0, "c33")
m.addConstr(-8 * hot_dogs + 5 * cheeseburgers >= 0, "c34")
m.addConstr(4 * pasta + 15 * hot_dogs <= 510, "c35")
m.addConstr(1 * steaks + 4 * pasta <= 369, "c36")
m.addConstr(34 * hot_dogs + 22 * cheeseburgers <= 249, "c37")
m.addConstr(3 * steaks + 34 * hot_dogs <= 417, "c38")
m.addConstr(18 * pasta + 22 * cheeseburgers <= 323, "c39")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)
