
import gurobipy as gp

# Create a new model
m = gp.Model("resource_allocation")

# Create variables
mary_hours = m.addVar(vtype=gp.GRB.INTEGER, name="mary_hours")
jean_hours = m.addVar(vtype=gp.GRB.CONTINUOUS, name="jean_hours")

# Set objective function
m.setObjective(7.28 * mary_hours**2 + 3.0 * mary_hours * jean_hours + 3.69 * jean_hours**2 + 8.12 * mary_hours + 8.29 * jean_hours, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(3.15 * mary_hours + 3.19 * jean_hours >= 5, "min_organization_score")
m.addConstr(2.73 * mary_hours + 1.4 * jean_hours >= 18, "min_paperwork_rating")
m.addConstr(-1 * mary_hours + 7 * jean_hours >= 0, "hours_relationship")
m.addConstr(3.15 * mary_hours + 3.19 * jean_hours <= 21, "max_organization_score")
m.addConstr(2.73 * mary_hours + 1.4 * jean_hours <= 36, "max_paperwork_rating")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal objective value: {m.objVal}")
    print(f"Mary's hours: {mary_hours.x}")
    print(f"Jean's hours: {jean_hours.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

