
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
mary_hours = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Mary")
jean_hours = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Jean")

# Objective function
obj_fn = 7.28 * mary_hours**2 + 3.0 * mary_hours * jean_hours + 3.69 * jean_hours**2 + 8.12 * mary_hours + 8.29 * jean_hours
m.setObjective(obj_fn, GRB.MAXIMIZE)

# Constraints
m.addConstr(3.15 * mary_hours + 3.19 * jean_hours >= 5, "min_org_score")
m.addConstr(2.73 * mary_hours + 1.4 * jean_hours >= 18, "min_paperwork_rating")
m.addConstr(-1 * mary_hours + 7 * jean_hours >= 0, "hours_constraint")
m.addConstr(3.15 * mary_hours + 3.19 * jean_hours <= 21, "max_org_score")
m.addConstr(2.73 * mary_hours + 1.4 * jean_hours <= 36, "max_paperwork_rating")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Mary: {mary_hours.x}")
    print(f"Hours worked by Jean: {jean_hours.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
