
import gurobipy as gp

# Create a new model
model = gp.Model("optimization_problem")

# Define variables
M = model.addVar(name="hours_worked_by_Mary", vtype=gp.GRB.INTEGER)  # Integer variable for Mary's hours
J = model.addVar(name="hours_worked_by_Jean")  # Continuous variable for Jean's hours

# Objective function
model.setObjective(7.28 * M**2 + 3.0 * M * J + 3.69 * J**2 + 8.12 * M + 8.29 * J, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(3.15 * M + 3.19 * J >= 5, name="org_score_min")  # Organization score minimum
model.addConstr(2.73 * M + 1.4 * J >= 18, name="paperwork_min")  # Paperwork minimum
model.addConstr(-M + 7 * J >= 0, name="jean_mary_ratio")  # Ratio of Jean's to Mary's hours
model.addConstr(3.15 * M + 3.19 * J <= 21, name="org_score_max")  # Organization score maximum
model.addConstr(2.73 * M + 1.4 * J <= 36, name="paperwork_max")  # Paperwork maximum

# Solve the model
model.optimize()

# Print solution
if model.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hours worked by Mary: {M.varValue}")
    print(f"Hours worked by Jean: {J.varValue}")
    print(f"Objective function value: {model.objVal}")
else:
    print("No optimal solution found.")
