
import gurobi as gp

# Define the variables
model = gp.Model("optimization_problem")

# Define the variables and their attributes
blue_highlighters = model.addVar(name="blue_highlighters", vtype=gp.GRB.INTEGER)
scissors = model.addVar(name="scissors", vtype=gp.GRB.INTEGER)
manila_envelopes = model.addVar(name="manila_envelopes", vtype=gp.GRB.INTEGER)
red_pens = model.addVar(name="red_pens", vtype=gp.GRB.INTEGER)
wooden_pencils = model.addVar(name="wooden_pencils", vtype=gp.GRB.INTEGER)
rubber_bands = model.addVar(name="rubber_bands", vtype=gp.GRB.INTEGER)
cafeteria_chairs = model.addVar(name="cafeteria_chairs", vtype=gp.GRB.INTEGER)

# Objective function
model.setObjective(5 * blue_highlighters + 7 * scissors + 8 * manila_envelopes + 
                   9 * red_pens + 2 * wooden_pencils + 3 * rubber_bands + 
                   6 * cafeteria_chairs, gp.GRB.MINIMIZE)

# Constraints
# Sustainability score constraints
model.addConstr(14 * blue_highlighters + 10 * scissors >= 24)
model.addConstr(10 * scissors + 3 * manila_envelopes >= 18)
model.addConstr(10 * scissors + 3 * red_pens >= 30)
model.addConstr(3 * red_pens + 6 * wooden_pencils >= 34)
model.addConstr(3 * manila_envelopes + 2 * cafeteria_chairs >= 47)
model.addConstr(9 * rubber_bands + 2 * cafeteria_chairs >= 30)
model.addConstr(14 * blue_highlighters + 10 * scissors + 3 * manila_envelopes >= 28)
model.addConstr(6 * wooden_pencils + 9 * rubber_bands + 2 * cafeteria_chairs >= 28)
model.addConstr(10 * scissors + 3 * red_pens + 2 * cafeteria_chairs >= 28)
model.addConstr(3 * red_pens + 6 * wooden_pencils + 9 * rubber_bands >= 28)

# ... (other constraints)

# Workplace safety impact constraints
model.addConstr(blue_highlighters + 7 * rubber_bands >= 22)
model.addConstr(3 * red_pens + 7 * rubber_bands >= 18)
model.addConstr(blue_highlighters + 13 * cafeteria_chairs >= 45)
model.addConstr(2 * wooden_pencils + 7 * rubber_bands >= 27)
model.addConstr(2 * wooden_pencils + 13 * cafeteria_chairs >= 30)
model.addConstr(scissors + 13 * cafeteria_chairs >= 25)

# Storage space constraints
model.addConstr(12 * blue_highlighters + 8 * cafeteria_chairs >= 38)
model.addConstr(11 * wooden_pencils + 8 * rubber_bands >= 49)
model.addConstr(7 * red_pens + 11 * wooden_pencils >= 39)
model.addConstr(7 * red_pens + 8 * rubber_bands >= 30)
model.addConstr(12 * blue_highlighters + 7 * manila_envelopes >= 36)

# Bounds
model.addConstr(14 * blue_highlighters + 10 * scissors + 6 * wooden_pencils <= 201)
model.addConstr(10 * scissors + 9 * rubber_bands + 2 * cafeteria_chairs <= 129)

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print("Objective: ", model.objVal)
    print("Blue Highlighters: ", blue_highlighters.varValue)
    print("Scissors: ", scissors.varValue)
    print("Manila Envelopes: ", manila_envelopes.varValue)
    print("Red Pens: ", red_pens.varValue)
    print("Wooden Pencils: ", wooden_pencils.varValue)
    print("Rubber Bands: ", rubber_bands.varValue)
    print("Cafeteria Chairs: ", cafeteria_chairs.varValue)
else:
    print("No optimal solution found")
