
from gurobipy import Model, GRB

# Create a new model
model = Model("nutrition_optimization")

# Create variables
magnesium = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="magnesium")
fiber = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="fiber")
vitamin_e = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="vitamin_e")
potassium = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="potassium")
vitamin_b1 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="vitamin_b1")

# Set objective function
model.setObjective(4.09 * magnesium + 2.57 * fiber + 2.4 * vitamin_e + 9.41 * potassium + 2.58 * vitamin_b1, GRB.MINIMIZE)

# Add constraints
model.addConstr(18 * fiber + 3 * vitamin_b1 >= 19, "c1")
model.addConstr(12 * magnesium + 3 * vitamin_b1 >= 27, "c2")
model.addConstr(18 * fiber + 15 * vitamin_e >= 18, "c3")
model.addConstr(15 * vitamin_e + 3 * vitamin_b1 >= 21, "c4")
model.addConstr(18 * fiber + 9 * potassium >= 18, "c5")
model.addConstr(12 * magnesium + 18 * fiber + 15 * vitamin_e + 9 * potassium + 3 * vitamin_b1 >= 18, "c6")
model.addConstr(-1 * magnesium + 7 * potassium >= 0, "c7")


# Optimize model
model.optimize()

# Check for infeasibility
if model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print optimal solution
    print("Optimal solution found:")
    print(f"Magnesium: {magnesium.x}")
    print(f"Fiber: {fiber.x}")
    print(f"Vitamin E: {vitamin_e.x}")
    print(f"Potassium: {potassium.x}")
    print(f"Vitamin B1: {vitamin_b1.x}")
    print(f"Objective value: {model.objVal}")

