
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables - since all variables are allowed to be non-integer (continuous), we use 'C' for Continuous
milligrams_of_magnesium = m.addVar(vtype=GRB.CONTINUOUS, name="milligrams_of_magnesium")
grams_of_fiber = m.addVar(vtype=GRB.CONTINUOUS, name="grams_of_fiber")
milligrams_of_vitamin_E = m.addVar(vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_E")
milligrams_of_potassium = m.addVar(vtype=GRB.CONTINUOUS, name="milligrams_of_potassium")
milligrams_of_vitamin_B1 = m.addVar(vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_B1")

# Objective function
m.setObjective(4.09 * milligrams_of_magnesium + 2.57 * grams_of_fiber + 
               2.40 * milligrams_of_vitamin_E + 9.41 * milligrams_of_potassium + 
               2.58 * milligrams_of_vitamin_B1, GRB.MINIMIZE)

# Constraints
m.addConstr(grams_of_fiber + milligrams_of_vitamin_B1 >= 19)
m.addConstr(milligrams_of_magnesium + milligrams_of_vitamin_B1 >= 27)
m.addConstr(grams_of_fiber + milligrams_of_vitamin_E >= 18)
m.addConstr(milligrams_of_vitamin_E + milligrams_of_vitamin_B1 >= 21)
m.addConstr(grams_of_fiber + milligrams_of_potassium >= 18)
m.addConstr(milligrams_of_magnesium + grams_of_fiber + milligrams_of_vitamin_E + 
            milligrams_of_potassium + milligrams_of_vitamin_B1 >= 18)
m.addConstr(-milligrams_of_magnesium + 7 * milligrams_of_potassium >= 0)

# Since the problem doesn't specify lower bounds for these variables, we assume they can be zero or more.
milligrams_of_magnesium.setAttr("LB", 0)
grams_of_fiber.setAttr("LB", 0)
milligrams_of_vitamin_E.setAttr("LB", 0)
milligrams_of_potassium.setAttr("LB", 0)
milligrams_of_vitamin_B1.setAttr("LB", 0)

# Solve the model
m.optimize()

# Output solution or indicate infeasibility
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    for var in [milligrams_of_magnesium, grams_of_fiber, milligrams_of_vitamin_E, 
                milligrams_of_potassium, milligrams_of_vitamin_B1]:
        print(f"{var.varName}: {var.x}")
else:
    print("Model is infeasible")
