
import gurobi

def optimize_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(lb=-gurobi.GRB.INFINITY, name="milligrams_of_magnesium", vtype=gurobi.GRB.CONTINUOUS)
    x1 = model.addVar(lb=-gurobi.GRB.INFINITY, name="grams_of_fiber", vtype=gurobi.GRB.CONTINUOUS)
    x2 = model.addVar(lb=-gurobi.GRB.INFINITY, name="milligrams_of_vitamin_E", vtype=gurobi.GRB.CONTINUOUS)
    x3 = model.addVar(lb=-gurobi.GRB.INFINITY, name="milligrams_of_potassium", vtype=gurobi.GRB.CONTINUOUS)
    x4 = model.addVar(lb=-gurobi.GRB.INFINITY, name="milligrams_of_vitamin_B1", vtype=gurobi.GRB.CONTINUOUS)

    # Objective function
    model.setObjective(4.09 * x0 + 2.57 * x1 + 2.4 * x2 + 9.41 * x3 + 2.58 * x4, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(x1 + x4 >= 19, name="constraint_1")
    model.addConstr(12 * x0 + 3 * x4 >= 27, name="constraint_2")
    model.addConstr(18 * x1 + 15 * x2 >= 18, name="constraint_3")
    model.addConstr(15 * x2 + 3 * x4 >= 21, name="constraint_4")
    model.addConstr(18 * x1 + 9 * x3 >= 18, name="constraint_5")
    model.addConstr(12 * x0 + 18 * x1 + 15 * x2 + 9 * x3 + 3 * x4 >= 18, name="constraint_6")
    model.addConstr(-x0 + 7 * x3 >= 0, name="constraint_7")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("Milligrams of magnesium: ", x0.varValue)
        print("Grams of fiber: ", x1.varValue)
        print("Milligrams of vitamin E: ", x2.varValue)
        print("Milligrams of potassium: ", x3.varValue)
        print("Milligrams of vitamin B1: ", x4.varValue)
    else:
        print("The problem is infeasible")

optimize_problem()
