
from gurobipy import Model, GRB

# Create a new model
m = Model("Military Optimization")

# Create variables
light_infantry = m.addVar(vtype=GRB.INTEGER, name="light_infantry")
air_defense = m.addVar(vtype=GRB.INTEGER, name="air_defense")
military_intelligence = m.addVar(vtype=GRB.INTEGER, name="military_intelligence")

# Set objective function
m.setObjective(6 * light_infantry + 6 * air_defense + 2 * military_intelligence, GRB.MAXIMIZE)

# Add constraints
m.addConstr(28 * light_infantry + 8 * air_defense + 22 * military_intelligence >= 31, "c0")
m.addConstr(24 * light_infantry + 11 * air_defense + 9 * military_intelligence >= 88, "c1")
m.addConstr(8 * air_defense + 22 * military_intelligence <= 105, "c2")
m.addConstr(28 * light_infantry + 22 * military_intelligence <= 123, "c3")
m.addConstr(28 * light_infantry + 8 * air_defense <= 126, "c4")
m.addConstr(28 * light_infantry + 8 * air_defense + 22 * military_intelligence <= 126, "c5")  # Redundant given c4 and non-negative variables.
m.addConstr(24 * light_infantry + 9 * military_intelligence <= 252, "c6")
m.addConstr(11 * air_defense + 9 * military_intelligence <= 212, "c7")
m.addConstr(24 * light_infantry + 11 * air_defense + 9 * military_intelligence <= 212, "c8")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('light_infantry:', light_infantry.x)
    print('air_defense:', air_defense.x)
    print('military_intelligence:', military_intelligence.x)
elif m.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

