
from gurobipy import *

# Create a new model
m = Model("Optimization_Model")

# Add variables (integer)
x0 = m.addVar(vtype=GRB.INTEGER, name="light_infantry_companies")
x1 = m.addVar(vtype=GRB.INTEGER, name="air_defense_batteries")
x2 = m.addVar(vtype=GRB.INTEGER, name="military_intelligence_companies")

# Objective function: Maximize 6*x0 + 6*x1 + 2*x2
m.setObjective(6*x0 + 6*x1 + 2*x2, GRB.MAXIMIZE)

# Constraints:
# Logistical capacity constraints
m.addConstr(28*x0 + 8*x1 + 22*x2 >= 31)  # Total logistical capacity must be at least 31
m.addConstr(8*x1 + 22*x2 <= 105)  # Combined logistical capacity of air defense and military intelligence
m.addConstr(28*x0 + 22*x2 <= 123)  # Combined logistical capacity of light infantry and military intelligence
m.addConstr(28*x0 + 8*x1 <= 126)  # Combined logistical capacity of light infantry and air defense
m.addConstr(28*x0 + 8*x1 + 22*x2 <= 139)  # Total logistical capacity

# Fuel demand constraints
m.addConstr(24*x0 + 11*x1 + 9*x2 >= 88)  # Total fuel demand must be at least 88 gal/day
m.addConstr(24*x0 + 9*x2 <= 252)  # Combined fuel demand of light infantry and military intelligence
m.addConstr(11*x1 + 9*x2 <= 212)  # Combined fuel demand of air defense and military intelligence
m.addConstr(24*x0 + 11*x1 + 9*x2 <= 212)  # Total fuel demand

# Solve the model
m.optimize()

# Print solution if found, otherwise print infeasibility message
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Light Infantry Companies: {x0.x}")
    print(f"Air Defense Batteries: {x1.x}")
    print(f"Military Intelligence Companies: {x2.x}")
else:
    print("Model is infeasible.")
