
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    light_infantry_companies = model.addVar(name="light_infantry_companies", vtype=gurobi.GRB.INTEGER)
    air_defense_batteries = model.addVar(name="air_defense_batteries", vtype=gurobi.GRB.INTEGER)
    military_intelligence_companies = model.addVar(name="military_intelligence_companies", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(6 * light_infantry_companies + 6 * air_defense_batteries + 2 * military_intelligence_companies, gurobi.GRB.MAXIMIZE)

    # Logistical capacity constraints
    model.addConstr(28 * light_infantry_companies + 8 * air_defense_batteries + 22 * military_intelligence_companies >= 31)
    model.addConstr(8 * air_defense_batteries + 22 * military_intelligence_companies <= 105)
    model.addConstr(28 * light_infantry_companies + 22 * military_intelligence_companies <= 123)
    model.addConstr(28 * light_infantry_companies + 8 * air_defense_batteries <= 126)
    model.addConstr(28 * light_infantry_companies + 8 * air_defense_batteries + 22 * military_intelligence_companies <= 126)

    # Fuel demand constraints
    model.addConstr(24 * light_infantry_companies + 11 * air_defense_batteries + 9 * military_intelligence_companies >= 88)
    model.addConstr(24 * light_infantry_companies + 9 * military_intelligence_companies <= 252)
    model.addConstr(11 * air_defense_batteries + 9 * military_intelligence_companies <= 212)
    model.addConstr(24 * light_infantry_companies + 11 * air_defense_batteries + 9 * military_intelligence_companies <= 212)

    # Non-negativity constraints (implied by Gurobi for integer variables)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Light Infantry Companies: {light_infantry_companies.varValue}")
        print(f"Air Defense Batteries: {air_defense_batteries.varValue}")
        print(f"Military Intelligence Companies: {military_intelligence_companies.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
