
import gurobipy as gp

# Create a new model
m = gp.Model("band_optimization")

# Create variables
ringo_hours = m.addVar(name="ringo_hours")
paul_hours = m.addVar(name="paul_hours")
jean_hours = m.addVar(name="jean_hours")
george_hours = m.addVar(name="george_hours")

# Set objective function
m.setObjective(6.22 * ringo_hours + 7.73 * paul_hours + 5.82 * jean_hours + 2.73 * george_hours, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(1 * ringo_hours + 12 * george_hours >= 98, "c1")
m.addConstr(15 * paul_hours + 12 * george_hours >= 73, "c2")
m.addConstr(1 * ringo_hours + 15 * paul_hours >= 77, "c3")
m.addConstr(1 * ringo_hours + 15 * paul_hours + 12 * george_hours >= 90, "c4")
m.addConstr(1 * ringo_hours + 15 * paul_hours + 16 * jean_hours + 12 * george_hours >= 90, "c5")

m.addConstr(1 * jean_hours + 15 * george_hours >= 44, "c6")
m.addConstr(4 * ringo_hours + 1 * jean_hours >= 47, "c7")
m.addConstr(3 * paul_hours + 1 * jean_hours >= 68, "c8")
m.addConstr(3 * paul_hours + 15 * george_hours >= 46, "c9")
m.addConstr(4 * ringo_hours + 3 * paul_hours >= 68, "c10")
m.addConstr(4 * ringo_hours + 3 * paul_hours + 1 * jean_hours + 15 * george_hours >= 68, "c11")

m.addConstr(12 * jean_hours + 12 * george_hours >= 43, "c12")
m.addConstr(14 * ringo_hours + 9 * paul_hours >= 48, "c13")
m.addConstr(14 * ringo_hours + 12 * george_hours >= 20, "c14")
m.addConstr(14 * ringo_hours + 9 * paul_hours + 12 * jean_hours >= 48, "c15")
m.addConstr(14 * ringo_hours + 12 * jean_hours + 12 * george_hours >= 48, "c16")
m.addConstr(14 * ringo_hours + 9 * paul_hours + 12 * george_hours >= 48, "c17")
m.addConstr(14 * ringo_hours + 9 * paul_hours + 12 * jean_hours >= 47, "c18")
m.addConstr(14 * ringo_hours + 12 * jean_hours + 12 * george_hours >= 47, "c19")
m.addConstr(14 * ringo_hours + 9 * paul_hours + 12 * george_hours >= 47, "c20")
m.addConstr(14 * ringo_hours + 9 * paul_hours + 12 * jean_hours >= 44, "c21")
m.addConstr(14 * ringo_hours + 12 * jean_hours + 12 * george_hours >= 44, "c22")
m.addConstr(14 * ringo_hours + 9 * paul_hours + 12 * george_hours >= 44, "c23")
m.addConstr(14 * ringo_hours + 9 * paul_hours + 12 * jean_hours + 12 * george_hours >= 44, "c24")


m.addConstr(9 * jean_hours + 8 * george_hours >= 20, "c25")
m.addConstr(2 * ringo_hours + 13 * paul_hours >= 33, "c26")
m.addConstr(2 * ringo_hours + 8 * george_hours >= 53, "c27")
m.addConstr(2 * ringo_hours + 9 * jean_hours >= 21, "c28")
m.addConstr(13 * paul_hours + 9 * jean_hours >= 54, "c29")
m.addConstr(2 * ringo_hours + 13 * paul_hours + 8 * george_hours >= 43, "c30")
m.addConstr(2 * ringo_hours + 13 * paul_hours + 9 * jean_hours + 8 * george_hours >= 43, "c31")

m.addConstr(2 * jean_hours + 16 * george_hours >= 49, "c32")
m.addConstr(14 * paul_hours + 2 * jean_hours >= 26, "c33")
m.addConstr(14 * paul_hours + 16 * george_hours >= 37, "c34")
m.addConstr(3 * ringo_hours + 16 * george_hours >= 28, "c35")
m.addConstr(3 * ringo_hours + 14 * paul_hours + 2 * jean_hours + 16 * george_hours >= 28, "c36")

m.addConstr(8 * paul_hours - 6 * george_hours >= 0, "c37")
m.addConstr(8 * jean_hours - 4 * george_hours >= 0, "c38")

m.addConstr(15 * paul_hours + 16 * jean_hours <= 159, "c39")
m.addConstr(4 * ringo_hours + 1 * jean_hours <= 150, "c40")
m.addConstr(1 * jean_hours + 15 * george_hours <= 160, "c41")
m.addConstr(3 * paul_hours + 1 * jean_hours <= 299, "c42")
m.addConstr(4 * ringo_hours + 3 * paul_hours <= 286, "c43")
m.addConstr(3 * paul_hours + 15 * george_hours <= 161, "c44")
m.addConstr(4 * ringo_hours + 3 * paul_hours + 15 * george_hours <= 221, "c45")

m.addConstr(9 * paul_hours + 12 * jean_hours <= 55, "c46")
m.addConstr(14 * ringo_hours + 12 * george_hours <= 110, "c47")
m.addConstr(14 * ringo_hours + 9 * paul_hours <= 63, "c48")

m.addConstr(2 * ringo_hours + 13 * paul_hours <= 72, "c49")
m.addConstr(13 * paul_hours + 8 * george_hours <= 62, "c50")
m.addConstr(2 * ringo_hours + 9 * jean_hours <= 235, "c51")
m.addConstr(2 * ringo_hours + 9 * jean_hours + 8 * george_hours <= 226, "c52")
m.addConstr(2 * ringo_hours + 13 * paul_hours + 8 * george_hours <= 85, "c53")
m.addConstr(2 * ringo_hours + 13 * paul_hours + 9 * jean_hours <= 125, "c54")

m.addConstr(2 * jean_hours + 16 * george_hours <= 206, "c55")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

