
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
R = m.addVar(lb=0, name="Ringo")
P = m.addVar(lb=0, name="Paul")
J = m.addVar(lb=0, name="Jean")
G = m.addVar(lb=0, name="George")

# Define the objective function
m.setObjective(6.22*R + 7.73*P + 5.82*J + 2.73*G, gp.GRB.MINIMIZE)

# Add constraints
# Ringo's constraints
m.addConstr(1*R <= 400)
m.addConstr(4*R <= 354)
m.addConstr(14*R <= 196)
m.addConstr(2*R <= 247)
m.addConstr(3*R <= 291)

# Paul's constraints
m.addConstr(15*P <= 400)
m.addConstr(3*P <= 354)
m.addConstr(9*P <= 196)
m.addConstr(13*P <= 247)
m.addConstr(14*P <= 291)

# Jean's constraints
m.addConstr(16*J <= 400)
m.addConstr(1*J <= 354)
m.addConstr(12*J <= 196)
m.addConstr(9*J <= 247)
m.addConstr(2*J <= 291)

# George's constraints
m.addConstr(12*G <= 400)
m.addConstr(15*G <= 354)
m.addConstr(12*G <= 196)
m.addConstr(8*G <= 247)
m.addConstr(16*G <= 291)

# Combined constraints
m.addConstr(1*R + 12*G >= 98)
m.addConstr(15*P + 12*G >= 73)
m.addConstr(1*R + 15*P >= 77)
m.addConstr(1*R + 15*P + 12*G >= 90)
m.addConstr(1*R + 15*P + 16*J + 12*G >= 90)
m.addConstr(1*J + 15*G >= 44)
m.addConstr(4*R + 1*J >= 47)
m.addConstr(3*P + 1*J >= 68)
m.addConstr(3*P + 15*G >= 46)
m.addConstr(4*R + 3*P >= 68)
m.addConstr(4*R + 3*P + 1*J + 15*G >= 68)
m.addConstr(12*J + 12*G >= 43)
m.addConstr(14*R + 9*P >= 48)
m.addConstr(14*R + 12*G >= 20)
m.addConstr(14*R + 9*P + 12*J >= 48)
m.addConstr(14*R + 12*J + 12*G >= 48)
m.addConstr(14*R + 9*P + 12*G >= 48)
m.addConstr(14*R + 9*P + 12*J >= 47)
m.addConstr(14*R + 12*J + 12*G >= 47)
m.addConstr(14*R + 9*P + 12*G >= 47)
m.addConstr(14*R + 9*P + 12*J >= 44)
m.addConstr(14*R + 12*J + 12*G >= 44)
m.addConstr(14*R + 9*P + 12*G >= 44)
m.addConstr(14*R + 9*P + 12*J + 12*G >= 44)
m.addConstr(9*J + 8*G >= 20)
m.addConstr(2*R + 13*P >= 33)
m.addConstr(2*R + 8*G >= 53)
m.addConstr(2*R + 9*J >= 21)
m.addConstr(13*P + 9*J >= 54)
m.addConstr(2*R + 13*P + 8*G >= 43)
m.addConstr(2*R + 13*P + 9*J + 8*G >= 43)
m.addConstr(2*J + 16*G >= 49)
m.addConstr(14*P + 2*J >= 26)
m.addConstr(14*P + 16*G >= 37)
m.addConstr(3*R + 16*G >= 28)
m.addConstr(3*R + 14*P + 2*J + 16*G >= 28)
m.addConstr(8*P - 6*G >= 0)
m.addConstr(8*J - 4*G >= 0)
m.addConstr(15*P + 16*J <= 159)
m.addConstr(4*R + 1*J <= 150)
m.addConstr(1*J + 15*G <= 160)
m.addConstr(3*P + 1*J <= 299)
m.addConstr(4*R + 3*P <= 286)
m.addConstr(3*P + 15*G <= 161)
m.addConstr(4*R + 3*P + 15*G <= 221)
m.addConstr(9*P + 12*J <= 55)
m.addConstr(14*R + 12*G <= 110)
m.addConstr(14*R + 9*P <= 63)
m.addConstr(2*R + 13*P <= 72)
m.addConstr(13*P + 8*G <= 62)
m.addConstr(2*R + 9*J <= 235)
m.addConstr(2*R + 9*J + 8*G <= 226)
m.addConstr(2*R + 13*P + 8*G <= 85)
m.addConstr(2*R + 13*P + 9*J <= 125)
m.addConstr(2*J + 16*G <= 206)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Ringo: ", R.varValue)
    print("Paul: ", P.varValue)
    print("Jean: ", J.varValue)
    print("George: ", G.varValue)
else:
    print("No optimal solution found")
