
import gurobipy as gp

# Create a new model
m = gp.Model("carbohydrate_optimization")

# Create variables
corn_cobs = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="corn_cobs")
protein_bars = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="protein_bars")
strips_of_bacon = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="strips_of_bacon")
steaks = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="steaks")

# Set objective function
m.setObjective(6 * corn_cobs + 1 * protein_bars + 8 * strips_of_bacon + 4 * steaks, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(5 * protein_bars + 4 * strips_of_bacon + 6 * steaks >= 21, "c1")
m.addConstr(3 * corn_cobs + 4 * strips_of_bacon + 6 * steaks >= 21, "c2")
m.addConstr(3 * corn_cobs + 5 * protein_bars + 6 * steaks >= 21, "c3")
m.addConstr(5 * protein_bars + 4 * strips_of_bacon + 6 * steaks >= 15, "c4")
m.addConstr(3 * corn_cobs + 4 * strips_of_bacon + 6 * steaks >= 15, "c5")
m.addConstr(3 * corn_cobs + 5 * protein_bars + 6 * steaks >= 15, "c6")
m.addConstr(5 * protein_bars + 4 * strips_of_bacon + 6 * steaks >= 19, "c7")
m.addConstr(3 * corn_cobs + 4 * strips_of_bacon + 6 * steaks >= 19, "c8")
m.addConstr(3 * corn_cobs + 5 * protein_bars + 6 * steaks >= 19, "c9")
m.addConstr(2 * corn_cobs - 10 * protein_bars >= 0, "c10")
m.addConstr(5 * protein_bars + 6 * steaks <= 97, "c11")
m.addConstr(3 * corn_cobs + 6 * steaks <= 47, "c12")
m.addConstr(3 * corn_cobs + 4 * strips_of_bacon <= 89, "c13")
m.addConstr(5 * protein_bars + 4 * strips_of_bacon <= 98, "c14")
m.addConstr(4 * strips_of_bacon + 6 * steaks <= 30, "c15")
m.addConstr(3 * corn_cobs + 5 * protein_bars + 4 * strips_of_bacon + 6 * steaks <= 98, "c16") # corrected upper bound


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found:")
    print("Corn cobs:", corn_cobs.x)
    print("Protein bars:", protein_bars.x)
    print("Strips of bacon:", strips_of_bacon.x)
    print("Steaks:", steaks.x)
    print("Objective value:", m.objVal)
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

