
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="corn_cobs")
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="protein_bars")
x2 = m.addVar(lb=0, vtype=GRB.INTEGER, name="strips_of_bacon")
x3 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="steaks")

# Objective function: Maximize 6*x0 + x1 + 8*x2 + 4*x3
m.setObjective(6*x0 + x1 + 8*x2 + 4*x3, GRB.MAXIMIZE)

# Constraints
# Carbohydrate constraints
m.addConstr(5*x1 + 4*x2 + 6*x3 >= 21, name="c1")
m.addConstr(3*x0 + 4*x2 + 6*x3 >= 21, name="c2")
m.addConstr(3*x0 + 5*x1 + 6*x3 >= 21, name="c3")
m.addConstr(5*x1 + 4*x2 + 6*x3 >= 15, name="c4")
m.addConstr(3*x0 + 4*x2 + 6*x3 >= 15, name="c5")
m.addConstr(3*x0 + 5*x1 + 6*x3 >= 15, name="c6")
m.addConstr(5*x1 + 4*x2 + 6*x3 >= 19, name="c7")
m.addConstr(3*x0 + 4*x2 + 6*x3 >= 19, name="c8")
m.addConstr(3*x0 + 5*x1 + 6*x3 >= 19, name="c9")

# Other constraints
m.addConstr(2*x0 - 10*x1 >= 0, name="c10")
m.addConstr(5*x1 + 6*x3 <= 97, name="c11")
m.addConstr(3*x0 + 6*x3 <= 47, name="c12")
m.addConstr(3*x0 + 4*x2 <= 89, name="c13")
m.addConstr(5*x1 + 4*x2 <= 98, name="c14")
m.addConstr(4*x2 + 6*x3 <= 30, name="c15")
m.addConstr(3*x0 + 5*x1 + 4*x2 + 6*x3 <= 30, name="c16")

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Corn cobs: {x0.x}")
    print(f"Protein bars: {x1.x}")
    print(f"Strips of bacon: {x2.x}")
    print(f"Steaks: {x3.x}")
else:
    print("No optimal solution found.")
