
from gurobipy import Model, GRB

# Create a new model
model = Model("vitamin_optimization")

# Create variables
b12 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="B12")
b9 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="B9")
fat = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Fat")
b5 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="B5")

# Set objective function
model.setObjective(4.44 * b12 + 1.36 * b9 + 2.79 * fat + 9.58 * b5, GRB.MAXIMIZE)

# Add constraints
model.addConstr(5 * fat + 16 * b5 >= 97, "c1")
model.addConstr(7 * b12 + 16 * b5 <= 339, "c2")
model.addConstr(7 * b12 + 1 * b9 <= 182, "c3")
model.addConstr(7 * b12 + 5 * fat <= 168, "c4")
model.addConstr(1 * b9 + 5 * fat + 16 * b5 <= 233, "c5")
model.addConstr(7 * b12 + 1 * b9 + 5 * fat + 16 * b5 <= 233, "c6")


# Optimize model
model.optimize()

if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    print('B12:', b12.x)
    print('B9:', b9.x)
    print('Fat:', fat.x)
    print('B5:', b5.x)
elif model.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % model.status)

